/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.HealthCheckType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HealthCheckConfig
implements Serializable,
Cloneable {
    private String iPAddress;
    private Integer port;
    private String type;
    private String resourcePath;
    private String fullyQualifiedDomainName;
    private String searchString;
    private Integer requestInterval;
    private Integer failureThreshold;
    private Boolean measureLatency;
    private Boolean inverted;
    private Integer healthThreshold;
    private ListWithAutoConstructFlag<String> childHealthChecks;

    public String getIPAddress() {
        return this.iPAddress;
    }

    public void setIPAddress(String iPAddress) {
        this.iPAddress = iPAddress;
    }

    public HealthCheckConfig withIPAddress(String iPAddress) {
        this.iPAddress = iPAddress;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public HealthCheckConfig withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public HealthCheckConfig withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(HealthCheckType type) {
        this.type = type.toString();
    }

    public HealthCheckConfig withType(HealthCheckType type) {
        this.type = type.toString();
        return this;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public HealthCheckConfig withResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
    }

    public HealthCheckConfig withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        return this;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public HealthCheckConfig withSearchString(String searchString) {
        this.searchString = searchString;
        return this;
    }

    public Integer getRequestInterval() {
        return this.requestInterval;
    }

    public void setRequestInterval(Integer requestInterval) {
        this.requestInterval = requestInterval;
    }

    public HealthCheckConfig withRequestInterval(Integer requestInterval) {
        this.requestInterval = requestInterval;
        return this;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public void setFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public HealthCheckConfig withFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public Boolean isMeasureLatency() {
        return this.measureLatency;
    }

    public void setMeasureLatency(Boolean measureLatency) {
        this.measureLatency = measureLatency;
    }

    public HealthCheckConfig withMeasureLatency(Boolean measureLatency) {
        this.measureLatency = measureLatency;
        return this;
    }

    public Boolean getMeasureLatency() {
        return this.measureLatency;
    }

    public Boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    public HealthCheckConfig withInverted(Boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    public Boolean getInverted() {
        return this.inverted;
    }

    public Integer getHealthThreshold() {
        return this.healthThreshold;
    }

    public void setHealthThreshold(Integer healthThreshold) {
        this.healthThreshold = healthThreshold;
    }

    public HealthCheckConfig withHealthThreshold(Integer healthThreshold) {
        this.healthThreshold = healthThreshold;
        return this;
    }

    public List<String> getChildHealthChecks() {
        if (this.childHealthChecks == null) {
            this.childHealthChecks = new ListWithAutoConstructFlag();
            this.childHealthChecks.setAutoConstruct(true);
        }
        return this.childHealthChecks;
    }

    public void setChildHealthChecks(Collection<String> childHealthChecks) {
        if (childHealthChecks == null) {
            this.childHealthChecks = null;
            return;
        }
        ListWithAutoConstructFlag childHealthChecksCopy = new ListWithAutoConstructFlag(childHealthChecks.size());
        childHealthChecksCopy.addAll(childHealthChecks);
        this.childHealthChecks = childHealthChecksCopy;
    }

    public HealthCheckConfig withChildHealthChecks(String ... childHealthChecks) {
        if (this.getChildHealthChecks() == null) {
            this.setChildHealthChecks(new ArrayList<String>(childHealthChecks.length));
        }
        for (String value : childHealthChecks) {
            this.getChildHealthChecks().add(value);
        }
        return this;
    }

    public HealthCheckConfig withChildHealthChecks(Collection<String> childHealthChecks) {
        if (childHealthChecks == null) {
            this.childHealthChecks = null;
        } else {
            ListWithAutoConstructFlag childHealthChecksCopy = new ListWithAutoConstructFlag(childHealthChecks.size());
            childHealthChecksCopy.addAll(childHealthChecks);
            this.childHealthChecks = childHealthChecksCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIPAddress() != null) {
            sb.append("IPAddress: " + this.getIPAddress() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getResourcePath() != null) {
            sb.append("ResourcePath: " + this.getResourcePath() + ",");
        }
        if (this.getFullyQualifiedDomainName() != null) {
            sb.append("FullyQualifiedDomainName: " + this.getFullyQualifiedDomainName() + ",");
        }
        if (this.getSearchString() != null) {
            sb.append("SearchString: " + this.getSearchString() + ",");
        }
        if (this.getRequestInterval() != null) {
            sb.append("RequestInterval: " + this.getRequestInterval() + ",");
        }
        if (this.getFailureThreshold() != null) {
            sb.append("FailureThreshold: " + this.getFailureThreshold() + ",");
        }
        if (this.isMeasureLatency() != null) {
            sb.append("MeasureLatency: " + this.isMeasureLatency() + ",");
        }
        if (this.isInverted() != null) {
            sb.append("Inverted: " + this.isInverted() + ",");
        }
        if (this.getHealthThreshold() != null) {
            sb.append("HealthThreshold: " + this.getHealthThreshold() + ",");
        }
        if (this.getChildHealthChecks() != null) {
            sb.append("ChildHealthChecks: " + this.getChildHealthChecks());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIPAddress() == null ? 0 : this.getIPAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getResourcePath() == null ? 0 : this.getResourcePath().hashCode());
        hashCode = 31 * hashCode + (this.getFullyQualifiedDomainName() == null ? 0 : this.getFullyQualifiedDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getSearchString() == null ? 0 : this.getSearchString().hashCode());
        hashCode = 31 * hashCode + (this.getRequestInterval() == null ? 0 : this.getRequestInterval().hashCode());
        hashCode = 31 * hashCode + (this.getFailureThreshold() == null ? 0 : this.getFailureThreshold().hashCode());
        hashCode = 31 * hashCode + (this.isMeasureLatency() == null ? 0 : this.isMeasureLatency().hashCode());
        hashCode = 31 * hashCode + (this.isInverted() == null ? 0 : this.isInverted().hashCode());
        hashCode = 31 * hashCode + (this.getHealthThreshold() == null ? 0 : this.getHealthThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getChildHealthChecks() == null ? 0 : this.getChildHealthChecks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        if (other.getIPAddress() == null ^ this.getIPAddress() == null) {
            return false;
        }
        if (other.getIPAddress() != null && !other.getIPAddress().equals(this.getIPAddress())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getResourcePath() == null ^ this.getResourcePath() == null) {
            return false;
        }
        if (other.getResourcePath() != null && !other.getResourcePath().equals(this.getResourcePath())) {
            return false;
        }
        if (other.getFullyQualifiedDomainName() == null ^ this.getFullyQualifiedDomainName() == null) {
            return false;
        }
        if (other.getFullyQualifiedDomainName() != null && !other.getFullyQualifiedDomainName().equals(this.getFullyQualifiedDomainName())) {
            return false;
        }
        if (other.getSearchString() == null ^ this.getSearchString() == null) {
            return false;
        }
        if (other.getSearchString() != null && !other.getSearchString().equals(this.getSearchString())) {
            return false;
        }
        if (other.getRequestInterval() == null ^ this.getRequestInterval() == null) {
            return false;
        }
        if (other.getRequestInterval() != null && !other.getRequestInterval().equals(this.getRequestInterval())) {
            return false;
        }
        if (other.getFailureThreshold() == null ^ this.getFailureThreshold() == null) {
            return false;
        }
        if (other.getFailureThreshold() != null && !other.getFailureThreshold().equals(this.getFailureThreshold())) {
            return false;
        }
        if (other.isMeasureLatency() == null ^ this.isMeasureLatency() == null) {
            return false;
        }
        if (other.isMeasureLatency() != null && !other.isMeasureLatency().equals(this.isMeasureLatency())) {
            return false;
        }
        if (other.isInverted() == null ^ this.isInverted() == null) {
            return false;
        }
        if (other.isInverted() != null && !other.isInverted().equals(this.isInverted())) {
            return false;
        }
        if (other.getHealthThreshold() == null ^ this.getHealthThreshold() == null) {
            return false;
        }
        if (other.getHealthThreshold() != null && !other.getHealthThreshold().equals(this.getHealthThreshold())) {
            return false;
        }
        if (other.getChildHealthChecks() == null ^ this.getChildHealthChecks() == null) {
            return false;
        }
        return other.getChildHealthChecks() == null || other.getChildHealthChecks().equals(this.getChildHealthChecks());
    }

    public HealthCheckConfig clone() {
        try {
            return (HealthCheckConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

