/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.robomaker.AWSRoboMakerAsync;
import com.amazonaws.services.robomaker.AWSRoboMakerAsyncClientBuilder;
import com.amazonaws.services.robomaker.AWSRoboMakerClient;
import com.amazonaws.services.robomaker.model.BatchDescribeSimulationJobRequest;
import com.amazonaws.services.robomaker.model.BatchDescribeSimulationJobResult;
import com.amazonaws.services.robomaker.model.CancelDeploymentJobRequest;
import com.amazonaws.services.robomaker.model.CancelDeploymentJobResult;
import com.amazonaws.services.robomaker.model.CancelSimulationJobRequest;
import com.amazonaws.services.robomaker.model.CancelSimulationJobResult;
import com.amazonaws.services.robomaker.model.CreateDeploymentJobRequest;
import com.amazonaws.services.robomaker.model.CreateDeploymentJobResult;
import com.amazonaws.services.robomaker.model.CreateFleetRequest;
import com.amazonaws.services.robomaker.model.CreateFleetResult;
import com.amazonaws.services.robomaker.model.CreateRobotApplicationRequest;
import com.amazonaws.services.robomaker.model.CreateRobotApplicationResult;
import com.amazonaws.services.robomaker.model.CreateRobotApplicationVersionRequest;
import com.amazonaws.services.robomaker.model.CreateRobotApplicationVersionResult;
import com.amazonaws.services.robomaker.model.CreateRobotRequest;
import com.amazonaws.services.robomaker.model.CreateRobotResult;
import com.amazonaws.services.robomaker.model.CreateSimulationApplicationRequest;
import com.amazonaws.services.robomaker.model.CreateSimulationApplicationResult;
import com.amazonaws.services.robomaker.model.CreateSimulationApplicationVersionRequest;
import com.amazonaws.services.robomaker.model.CreateSimulationApplicationVersionResult;
import com.amazonaws.services.robomaker.model.CreateSimulationJobRequest;
import com.amazonaws.services.robomaker.model.CreateSimulationJobResult;
import com.amazonaws.services.robomaker.model.DeleteFleetRequest;
import com.amazonaws.services.robomaker.model.DeleteFleetResult;
import com.amazonaws.services.robomaker.model.DeleteRobotApplicationRequest;
import com.amazonaws.services.robomaker.model.DeleteRobotApplicationResult;
import com.amazonaws.services.robomaker.model.DeleteRobotRequest;
import com.amazonaws.services.robomaker.model.DeleteRobotResult;
import com.amazonaws.services.robomaker.model.DeleteSimulationApplicationRequest;
import com.amazonaws.services.robomaker.model.DeleteSimulationApplicationResult;
import com.amazonaws.services.robomaker.model.DeregisterRobotRequest;
import com.amazonaws.services.robomaker.model.DeregisterRobotResult;
import com.amazonaws.services.robomaker.model.DescribeDeploymentJobRequest;
import com.amazonaws.services.robomaker.model.DescribeDeploymentJobResult;
import com.amazonaws.services.robomaker.model.DescribeFleetRequest;
import com.amazonaws.services.robomaker.model.DescribeFleetResult;
import com.amazonaws.services.robomaker.model.DescribeRobotApplicationRequest;
import com.amazonaws.services.robomaker.model.DescribeRobotApplicationResult;
import com.amazonaws.services.robomaker.model.DescribeRobotRequest;
import com.amazonaws.services.robomaker.model.DescribeRobotResult;
import com.amazonaws.services.robomaker.model.DescribeSimulationApplicationRequest;
import com.amazonaws.services.robomaker.model.DescribeSimulationApplicationResult;
import com.amazonaws.services.robomaker.model.DescribeSimulationJobRequest;
import com.amazonaws.services.robomaker.model.DescribeSimulationJobResult;
import com.amazonaws.services.robomaker.model.ListDeploymentJobsRequest;
import com.amazonaws.services.robomaker.model.ListDeploymentJobsResult;
import com.amazonaws.services.robomaker.model.ListFleetsRequest;
import com.amazonaws.services.robomaker.model.ListFleetsResult;
import com.amazonaws.services.robomaker.model.ListRobotApplicationsRequest;
import com.amazonaws.services.robomaker.model.ListRobotApplicationsResult;
import com.amazonaws.services.robomaker.model.ListRobotsRequest;
import com.amazonaws.services.robomaker.model.ListRobotsResult;
import com.amazonaws.services.robomaker.model.ListSimulationApplicationsRequest;
import com.amazonaws.services.robomaker.model.ListSimulationApplicationsResult;
import com.amazonaws.services.robomaker.model.ListSimulationJobsRequest;
import com.amazonaws.services.robomaker.model.ListSimulationJobsResult;
import com.amazonaws.services.robomaker.model.ListTagsForResourceRequest;
import com.amazonaws.services.robomaker.model.ListTagsForResourceResult;
import com.amazonaws.services.robomaker.model.RegisterRobotRequest;
import com.amazonaws.services.robomaker.model.RegisterRobotResult;
import com.amazonaws.services.robomaker.model.RestartSimulationJobRequest;
import com.amazonaws.services.robomaker.model.RestartSimulationJobResult;
import com.amazonaws.services.robomaker.model.SyncDeploymentJobRequest;
import com.amazonaws.services.robomaker.model.SyncDeploymentJobResult;
import com.amazonaws.services.robomaker.model.TagResourceRequest;
import com.amazonaws.services.robomaker.model.TagResourceResult;
import com.amazonaws.services.robomaker.model.UntagResourceRequest;
import com.amazonaws.services.robomaker.model.UntagResourceResult;
import com.amazonaws.services.robomaker.model.UpdateRobotApplicationRequest;
import com.amazonaws.services.robomaker.model.UpdateRobotApplicationResult;
import com.amazonaws.services.robomaker.model.UpdateSimulationApplicationRequest;
import com.amazonaws.services.robomaker.model.UpdateSimulationApplicationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRoboMakerAsyncClient
extends AWSRoboMakerClient
implements AWSRoboMakerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRoboMakerAsyncClientBuilder asyncBuilder() {
        return AWSRoboMakerAsyncClientBuilder.standard();
    }

    AWSRoboMakerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchDescribeSimulationJobResult> batchDescribeSimulationJobAsync(BatchDescribeSimulationJobRequest request) {
        return this.batchDescribeSimulationJobAsync(request, null);
    }

    @Override
    public Future<BatchDescribeSimulationJobResult> batchDescribeSimulationJobAsync(BatchDescribeSimulationJobRequest request, final AsyncHandler<BatchDescribeSimulationJobRequest, BatchDescribeSimulationJobResult> asyncHandler) {
        final BatchDescribeSimulationJobRequest finalRequest = (BatchDescribeSimulationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDescribeSimulationJobResult>(){

            @Override
            public BatchDescribeSimulationJobResult call() throws Exception {
                BatchDescribeSimulationJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeBatchDescribeSimulationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelDeploymentJobResult> cancelDeploymentJobAsync(CancelDeploymentJobRequest request) {
        return this.cancelDeploymentJobAsync(request, null);
    }

    @Override
    public Future<CancelDeploymentJobResult> cancelDeploymentJobAsync(CancelDeploymentJobRequest request, final AsyncHandler<CancelDeploymentJobRequest, CancelDeploymentJobResult> asyncHandler) {
        final CancelDeploymentJobRequest finalRequest = (CancelDeploymentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelDeploymentJobResult>(){

            @Override
            public CancelDeploymentJobResult call() throws Exception {
                CancelDeploymentJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCancelDeploymentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelSimulationJobResult> cancelSimulationJobAsync(CancelSimulationJobRequest request) {
        return this.cancelSimulationJobAsync(request, null);
    }

    @Override
    public Future<CancelSimulationJobResult> cancelSimulationJobAsync(CancelSimulationJobRequest request, final AsyncHandler<CancelSimulationJobRequest, CancelSimulationJobResult> asyncHandler) {
        final CancelSimulationJobRequest finalRequest = (CancelSimulationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelSimulationJobResult>(){

            @Override
            public CancelSimulationJobResult call() throws Exception {
                CancelSimulationJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCancelSimulationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDeploymentJobResult> createDeploymentJobAsync(CreateDeploymentJobRequest request) {
        return this.createDeploymentJobAsync(request, null);
    }

    @Override
    public Future<CreateDeploymentJobResult> createDeploymentJobAsync(CreateDeploymentJobRequest request, final AsyncHandler<CreateDeploymentJobRequest, CreateDeploymentJobResult> asyncHandler) {
        final CreateDeploymentJobRequest finalRequest = (CreateDeploymentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDeploymentJobResult>(){

            @Override
            public CreateDeploymentJobResult call() throws Exception {
                CreateDeploymentJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateDeploymentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request) {
        return this.createFleetAsync(request, null);
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request, final AsyncHandler<CreateFleetRequest, CreateFleetResult> asyncHandler) {
        final CreateFleetRequest finalRequest = (CreateFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFleetResult>(){

            @Override
            public CreateFleetResult call() throws Exception {
                CreateFleetResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRobotResult> createRobotAsync(CreateRobotRequest request) {
        return this.createRobotAsync(request, null);
    }

    @Override
    public Future<CreateRobotResult> createRobotAsync(CreateRobotRequest request, final AsyncHandler<CreateRobotRequest, CreateRobotResult> asyncHandler) {
        final CreateRobotRequest finalRequest = (CreateRobotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRobotResult>(){

            @Override
            public CreateRobotResult call() throws Exception {
                CreateRobotResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateRobot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRobotApplicationResult> createRobotApplicationAsync(CreateRobotApplicationRequest request) {
        return this.createRobotApplicationAsync(request, null);
    }

    @Override
    public Future<CreateRobotApplicationResult> createRobotApplicationAsync(CreateRobotApplicationRequest request, final AsyncHandler<CreateRobotApplicationRequest, CreateRobotApplicationResult> asyncHandler) {
        final CreateRobotApplicationRequest finalRequest = (CreateRobotApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRobotApplicationResult>(){

            @Override
            public CreateRobotApplicationResult call() throws Exception {
                CreateRobotApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateRobotApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRobotApplicationVersionResult> createRobotApplicationVersionAsync(CreateRobotApplicationVersionRequest request) {
        return this.createRobotApplicationVersionAsync(request, null);
    }

    @Override
    public Future<CreateRobotApplicationVersionResult> createRobotApplicationVersionAsync(CreateRobotApplicationVersionRequest request, final AsyncHandler<CreateRobotApplicationVersionRequest, CreateRobotApplicationVersionResult> asyncHandler) {
        final CreateRobotApplicationVersionRequest finalRequest = (CreateRobotApplicationVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRobotApplicationVersionResult>(){

            @Override
            public CreateRobotApplicationVersionResult call() throws Exception {
                CreateRobotApplicationVersionResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateRobotApplicationVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSimulationApplicationResult> createSimulationApplicationAsync(CreateSimulationApplicationRequest request) {
        return this.createSimulationApplicationAsync(request, null);
    }

    @Override
    public Future<CreateSimulationApplicationResult> createSimulationApplicationAsync(CreateSimulationApplicationRequest request, final AsyncHandler<CreateSimulationApplicationRequest, CreateSimulationApplicationResult> asyncHandler) {
        final CreateSimulationApplicationRequest finalRequest = (CreateSimulationApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSimulationApplicationResult>(){

            @Override
            public CreateSimulationApplicationResult call() throws Exception {
                CreateSimulationApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateSimulationApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSimulationApplicationVersionResult> createSimulationApplicationVersionAsync(CreateSimulationApplicationVersionRequest request) {
        return this.createSimulationApplicationVersionAsync(request, null);
    }

    @Override
    public Future<CreateSimulationApplicationVersionResult> createSimulationApplicationVersionAsync(CreateSimulationApplicationVersionRequest request, final AsyncHandler<CreateSimulationApplicationVersionRequest, CreateSimulationApplicationVersionResult> asyncHandler) {
        final CreateSimulationApplicationVersionRequest finalRequest = (CreateSimulationApplicationVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSimulationApplicationVersionResult>(){

            @Override
            public CreateSimulationApplicationVersionResult call() throws Exception {
                CreateSimulationApplicationVersionResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateSimulationApplicationVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSimulationJobResult> createSimulationJobAsync(CreateSimulationJobRequest request) {
        return this.createSimulationJobAsync(request, null);
    }

    @Override
    public Future<CreateSimulationJobResult> createSimulationJobAsync(CreateSimulationJobRequest request, final AsyncHandler<CreateSimulationJobRequest, CreateSimulationJobResult> asyncHandler) {
        final CreateSimulationJobRequest finalRequest = (CreateSimulationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSimulationJobResult>(){

            @Override
            public CreateSimulationJobResult call() throws Exception {
                CreateSimulationJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeCreateSimulationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request) {
        return this.deleteFleetAsync(request, null);
    }

    @Override
    public Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request, final AsyncHandler<DeleteFleetRequest, DeleteFleetResult> asyncHandler) {
        final DeleteFleetRequest finalRequest = (DeleteFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFleetResult>(){

            @Override
            public DeleteFleetResult call() throws Exception {
                DeleteFleetResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDeleteFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRobotResult> deleteRobotAsync(DeleteRobotRequest request) {
        return this.deleteRobotAsync(request, null);
    }

    @Override
    public Future<DeleteRobotResult> deleteRobotAsync(DeleteRobotRequest request, final AsyncHandler<DeleteRobotRequest, DeleteRobotResult> asyncHandler) {
        final DeleteRobotRequest finalRequest = (DeleteRobotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRobotResult>(){

            @Override
            public DeleteRobotResult call() throws Exception {
                DeleteRobotResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDeleteRobot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRobotApplicationResult> deleteRobotApplicationAsync(DeleteRobotApplicationRequest request) {
        return this.deleteRobotApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteRobotApplicationResult> deleteRobotApplicationAsync(DeleteRobotApplicationRequest request, final AsyncHandler<DeleteRobotApplicationRequest, DeleteRobotApplicationResult> asyncHandler) {
        final DeleteRobotApplicationRequest finalRequest = (DeleteRobotApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRobotApplicationResult>(){

            @Override
            public DeleteRobotApplicationResult call() throws Exception {
                DeleteRobotApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDeleteRobotApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSimulationApplicationResult> deleteSimulationApplicationAsync(DeleteSimulationApplicationRequest request) {
        return this.deleteSimulationApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteSimulationApplicationResult> deleteSimulationApplicationAsync(DeleteSimulationApplicationRequest request, final AsyncHandler<DeleteSimulationApplicationRequest, DeleteSimulationApplicationResult> asyncHandler) {
        final DeleteSimulationApplicationRequest finalRequest = (DeleteSimulationApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSimulationApplicationResult>(){

            @Override
            public DeleteSimulationApplicationResult call() throws Exception {
                DeleteSimulationApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDeleteSimulationApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterRobotResult> deregisterRobotAsync(DeregisterRobotRequest request) {
        return this.deregisterRobotAsync(request, null);
    }

    @Override
    public Future<DeregisterRobotResult> deregisterRobotAsync(DeregisterRobotRequest request, final AsyncHandler<DeregisterRobotRequest, DeregisterRobotResult> asyncHandler) {
        final DeregisterRobotRequest finalRequest = (DeregisterRobotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterRobotResult>(){

            @Override
            public DeregisterRobotResult call() throws Exception {
                DeregisterRobotResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDeregisterRobot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeploymentJobResult> describeDeploymentJobAsync(DescribeDeploymentJobRequest request) {
        return this.describeDeploymentJobAsync(request, null);
    }

    @Override
    public Future<DescribeDeploymentJobResult> describeDeploymentJobAsync(DescribeDeploymentJobRequest request, final AsyncHandler<DescribeDeploymentJobRequest, DescribeDeploymentJobResult> asyncHandler) {
        final DescribeDeploymentJobRequest finalRequest = (DescribeDeploymentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeploymentJobResult>(){

            @Override
            public DescribeDeploymentJobResult call() throws Exception {
                DescribeDeploymentJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDescribeDeploymentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetResult> describeFleetAsync(DescribeFleetRequest request) {
        return this.describeFleetAsync(request, null);
    }

    @Override
    public Future<DescribeFleetResult> describeFleetAsync(DescribeFleetRequest request, final AsyncHandler<DescribeFleetRequest, DescribeFleetResult> asyncHandler) {
        final DescribeFleetRequest finalRequest = (DescribeFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFleetResult>(){

            @Override
            public DescribeFleetResult call() throws Exception {
                DescribeFleetResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDescribeFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRobotResult> describeRobotAsync(DescribeRobotRequest request) {
        return this.describeRobotAsync(request, null);
    }

    @Override
    public Future<DescribeRobotResult> describeRobotAsync(DescribeRobotRequest request, final AsyncHandler<DescribeRobotRequest, DescribeRobotResult> asyncHandler) {
        final DescribeRobotRequest finalRequest = (DescribeRobotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRobotResult>(){

            @Override
            public DescribeRobotResult call() throws Exception {
                DescribeRobotResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDescribeRobot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRobotApplicationResult> describeRobotApplicationAsync(DescribeRobotApplicationRequest request) {
        return this.describeRobotApplicationAsync(request, null);
    }

    @Override
    public Future<DescribeRobotApplicationResult> describeRobotApplicationAsync(DescribeRobotApplicationRequest request, final AsyncHandler<DescribeRobotApplicationRequest, DescribeRobotApplicationResult> asyncHandler) {
        final DescribeRobotApplicationRequest finalRequest = (DescribeRobotApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRobotApplicationResult>(){

            @Override
            public DescribeRobotApplicationResult call() throws Exception {
                DescribeRobotApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDescribeRobotApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSimulationApplicationResult> describeSimulationApplicationAsync(DescribeSimulationApplicationRequest request) {
        return this.describeSimulationApplicationAsync(request, null);
    }

    @Override
    public Future<DescribeSimulationApplicationResult> describeSimulationApplicationAsync(DescribeSimulationApplicationRequest request, final AsyncHandler<DescribeSimulationApplicationRequest, DescribeSimulationApplicationResult> asyncHandler) {
        final DescribeSimulationApplicationRequest finalRequest = (DescribeSimulationApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSimulationApplicationResult>(){

            @Override
            public DescribeSimulationApplicationResult call() throws Exception {
                DescribeSimulationApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDescribeSimulationApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSimulationJobResult> describeSimulationJobAsync(DescribeSimulationJobRequest request) {
        return this.describeSimulationJobAsync(request, null);
    }

    @Override
    public Future<DescribeSimulationJobResult> describeSimulationJobAsync(DescribeSimulationJobRequest request, final AsyncHandler<DescribeSimulationJobRequest, DescribeSimulationJobResult> asyncHandler) {
        final DescribeSimulationJobRequest finalRequest = (DescribeSimulationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSimulationJobResult>(){

            @Override
            public DescribeSimulationJobResult call() throws Exception {
                DescribeSimulationJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeDescribeSimulationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentJobsResult> listDeploymentJobsAsync(ListDeploymentJobsRequest request) {
        return this.listDeploymentJobsAsync(request, null);
    }

    @Override
    public Future<ListDeploymentJobsResult> listDeploymentJobsAsync(ListDeploymentJobsRequest request, final AsyncHandler<ListDeploymentJobsRequest, ListDeploymentJobsResult> asyncHandler) {
        final ListDeploymentJobsRequest finalRequest = (ListDeploymentJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeploymentJobsResult>(){

            @Override
            public ListDeploymentJobsResult call() throws Exception {
                ListDeploymentJobsResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeListDeploymentJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request) {
        return this.listFleetsAsync(request, null);
    }

    @Override
    public Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request, final AsyncHandler<ListFleetsRequest, ListFleetsResult> asyncHandler) {
        final ListFleetsRequest finalRequest = (ListFleetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFleetsResult>(){

            @Override
            public ListFleetsResult call() throws Exception {
                ListFleetsResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeListFleets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRobotApplicationsResult> listRobotApplicationsAsync(ListRobotApplicationsRequest request) {
        return this.listRobotApplicationsAsync(request, null);
    }

    @Override
    public Future<ListRobotApplicationsResult> listRobotApplicationsAsync(ListRobotApplicationsRequest request, final AsyncHandler<ListRobotApplicationsRequest, ListRobotApplicationsResult> asyncHandler) {
        final ListRobotApplicationsRequest finalRequest = (ListRobotApplicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRobotApplicationsResult>(){

            @Override
            public ListRobotApplicationsResult call() throws Exception {
                ListRobotApplicationsResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeListRobotApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRobotsResult> listRobotsAsync(ListRobotsRequest request) {
        return this.listRobotsAsync(request, null);
    }

    @Override
    public Future<ListRobotsResult> listRobotsAsync(ListRobotsRequest request, final AsyncHandler<ListRobotsRequest, ListRobotsResult> asyncHandler) {
        final ListRobotsRequest finalRequest = (ListRobotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRobotsResult>(){

            @Override
            public ListRobotsResult call() throws Exception {
                ListRobotsResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeListRobots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSimulationApplicationsResult> listSimulationApplicationsAsync(ListSimulationApplicationsRequest request) {
        return this.listSimulationApplicationsAsync(request, null);
    }

    @Override
    public Future<ListSimulationApplicationsResult> listSimulationApplicationsAsync(ListSimulationApplicationsRequest request, final AsyncHandler<ListSimulationApplicationsRequest, ListSimulationApplicationsResult> asyncHandler) {
        final ListSimulationApplicationsRequest finalRequest = (ListSimulationApplicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSimulationApplicationsResult>(){

            @Override
            public ListSimulationApplicationsResult call() throws Exception {
                ListSimulationApplicationsResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeListSimulationApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSimulationJobsResult> listSimulationJobsAsync(ListSimulationJobsRequest request) {
        return this.listSimulationJobsAsync(request, null);
    }

    @Override
    public Future<ListSimulationJobsResult> listSimulationJobsAsync(ListSimulationJobsRequest request, final AsyncHandler<ListSimulationJobsRequest, ListSimulationJobsResult> asyncHandler) {
        final ListSimulationJobsRequest finalRequest = (ListSimulationJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSimulationJobsResult>(){

            @Override
            public ListSimulationJobsResult call() throws Exception {
                ListSimulationJobsResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeListSimulationJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterRobotResult> registerRobotAsync(RegisterRobotRequest request) {
        return this.registerRobotAsync(request, null);
    }

    @Override
    public Future<RegisterRobotResult> registerRobotAsync(RegisterRobotRequest request, final AsyncHandler<RegisterRobotRequest, RegisterRobotResult> asyncHandler) {
        final RegisterRobotRequest finalRequest = (RegisterRobotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterRobotResult>(){

            @Override
            public RegisterRobotResult call() throws Exception {
                RegisterRobotResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeRegisterRobot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestartSimulationJobResult> restartSimulationJobAsync(RestartSimulationJobRequest request) {
        return this.restartSimulationJobAsync(request, null);
    }

    @Override
    public Future<RestartSimulationJobResult> restartSimulationJobAsync(RestartSimulationJobRequest request, final AsyncHandler<RestartSimulationJobRequest, RestartSimulationJobResult> asyncHandler) {
        final RestartSimulationJobRequest finalRequest = (RestartSimulationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestartSimulationJobResult>(){

            @Override
            public RestartSimulationJobResult call() throws Exception {
                RestartSimulationJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeRestartSimulationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SyncDeploymentJobResult> syncDeploymentJobAsync(SyncDeploymentJobRequest request) {
        return this.syncDeploymentJobAsync(request, null);
    }

    @Override
    public Future<SyncDeploymentJobResult> syncDeploymentJobAsync(SyncDeploymentJobRequest request, final AsyncHandler<SyncDeploymentJobRequest, SyncDeploymentJobResult> asyncHandler) {
        final SyncDeploymentJobRequest finalRequest = (SyncDeploymentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SyncDeploymentJobResult>(){

            @Override
            public SyncDeploymentJobResult call() throws Exception {
                SyncDeploymentJobResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeSyncDeploymentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRobotApplicationResult> updateRobotApplicationAsync(UpdateRobotApplicationRequest request) {
        return this.updateRobotApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateRobotApplicationResult> updateRobotApplicationAsync(UpdateRobotApplicationRequest request, final AsyncHandler<UpdateRobotApplicationRequest, UpdateRobotApplicationResult> asyncHandler) {
        final UpdateRobotApplicationRequest finalRequest = (UpdateRobotApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRobotApplicationResult>(){

            @Override
            public UpdateRobotApplicationResult call() throws Exception {
                UpdateRobotApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeUpdateRobotApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSimulationApplicationResult> updateSimulationApplicationAsync(UpdateSimulationApplicationRequest request) {
        return this.updateSimulationApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateSimulationApplicationResult> updateSimulationApplicationAsync(UpdateSimulationApplicationRequest request, final AsyncHandler<UpdateSimulationApplicationRequest, UpdateSimulationApplicationResult> asyncHandler) {
        final UpdateSimulationApplicationRequest finalRequest = (UpdateSimulationApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSimulationApplicationResult>(){

            @Override
            public UpdateSimulationApplicationResult call() throws Exception {
                UpdateSimulationApplicationResult result = null;
                try {
                    result = AWSRoboMakerAsyncClient.this.executeUpdateSimulationApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

