/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.FailureBehavior;
import com.amazonaws.services.robomaker.model.OutputLocation;
import com.amazonaws.services.robomaker.model.RobotApplicationConfig;
import com.amazonaws.services.robomaker.model.SimulationApplicationConfig;
import com.amazonaws.services.robomaker.model.SimulationJobErrorCode;
import com.amazonaws.services.robomaker.model.SimulationJobStatus;
import com.amazonaws.services.robomaker.model.VPCConfigResponse;
import com.amazonaws.services.robomaker.model.transform.SimulationJobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimulationJob
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String status;
    private Date lastUpdatedAt;
    private String failureBehavior;
    private String failureCode;
    private String failureReason;
    private String clientRequestToken;
    private OutputLocation outputLocation;
    private Long maxJobDurationInSeconds;
    private Long simulationTimeMillis;
    private String iamRole;
    private List<RobotApplicationConfig> robotApplications;
    private List<SimulationApplicationConfig> simulationApplications;
    private Map<String, String> tags;
    private VPCConfigResponse vpcConfig;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public SimulationJob withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SimulationJob withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public SimulationJob withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public SimulationJob withStatus(SimulationJobStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public SimulationJob withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public void setFailureBehavior(String failureBehavior) {
        this.failureBehavior = failureBehavior;
    }

    public String getFailureBehavior() {
        return this.failureBehavior;
    }

    public SimulationJob withFailureBehavior(String failureBehavior) {
        this.setFailureBehavior(failureBehavior);
        return this;
    }

    public SimulationJob withFailureBehavior(FailureBehavior failureBehavior) {
        this.failureBehavior = failureBehavior.toString();
        return this;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public SimulationJob withFailureCode(String failureCode) {
        this.setFailureCode(failureCode);
        return this;
    }

    public SimulationJob withFailureCode(SimulationJobErrorCode failureCode) {
        this.failureCode = failureCode.toString();
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public SimulationJob withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public SimulationJob withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public SimulationJob withOutputLocation(OutputLocation outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        this.maxJobDurationInSeconds = maxJobDurationInSeconds;
    }

    public Long getMaxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public SimulationJob withMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
        this.setMaxJobDurationInSeconds(maxJobDurationInSeconds);
        return this;
    }

    public void setSimulationTimeMillis(Long simulationTimeMillis) {
        this.simulationTimeMillis = simulationTimeMillis;
    }

    public Long getSimulationTimeMillis() {
        return this.simulationTimeMillis;
    }

    public SimulationJob withSimulationTimeMillis(Long simulationTimeMillis) {
        this.setSimulationTimeMillis(simulationTimeMillis);
        return this;
    }

    public void setIamRole(String iamRole) {
        this.iamRole = iamRole;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    public SimulationJob withIamRole(String iamRole) {
        this.setIamRole(iamRole);
        return this;
    }

    public List<RobotApplicationConfig> getRobotApplications() {
        return this.robotApplications;
    }

    public void setRobotApplications(Collection<RobotApplicationConfig> robotApplications) {
        if (robotApplications == null) {
            this.robotApplications = null;
            return;
        }
        this.robotApplications = new ArrayList<RobotApplicationConfig>(robotApplications);
    }

    public SimulationJob withRobotApplications(RobotApplicationConfig ... robotApplications) {
        if (this.robotApplications == null) {
            this.setRobotApplications(new ArrayList<RobotApplicationConfig>(robotApplications.length));
        }
        for (RobotApplicationConfig ele : robotApplications) {
            this.robotApplications.add(ele);
        }
        return this;
    }

    public SimulationJob withRobotApplications(Collection<RobotApplicationConfig> robotApplications) {
        this.setRobotApplications(robotApplications);
        return this;
    }

    public List<SimulationApplicationConfig> getSimulationApplications() {
        return this.simulationApplications;
    }

    public void setSimulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
        if (simulationApplications == null) {
            this.simulationApplications = null;
            return;
        }
        this.simulationApplications = new ArrayList<SimulationApplicationConfig>(simulationApplications);
    }

    public SimulationJob withSimulationApplications(SimulationApplicationConfig ... simulationApplications) {
        if (this.simulationApplications == null) {
            this.setSimulationApplications(new ArrayList<SimulationApplicationConfig>(simulationApplications.length));
        }
        for (SimulationApplicationConfig ele : simulationApplications) {
            this.simulationApplications.add(ele);
        }
        return this;
    }

    public SimulationJob withSimulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
        this.setSimulationApplications(simulationApplications);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public SimulationJob withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public SimulationJob addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public SimulationJob clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setVpcConfig(VPCConfigResponse vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VPCConfigResponse getVpcConfig() {
        return this.vpcConfig;
    }

    public SimulationJob withVpcConfig(VPCConfigResponse vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt()).append(",");
        }
        if (this.getFailureBehavior() != null) {
            sb.append("FailureBehavior: ").append(this.getFailureBehavior()).append(",");
        }
        if (this.getFailureCode() != null) {
            sb.append("FailureCode: ").append(this.getFailureCode()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation()).append(",");
        }
        if (this.getMaxJobDurationInSeconds() != null) {
            sb.append("MaxJobDurationInSeconds: ").append(this.getMaxJobDurationInSeconds()).append(",");
        }
        if (this.getSimulationTimeMillis() != null) {
            sb.append("SimulationTimeMillis: ").append(this.getSimulationTimeMillis()).append(",");
        }
        if (this.getIamRole() != null) {
            sb.append("IamRole: ").append(this.getIamRole()).append(",");
        }
        if (this.getRobotApplications() != null) {
            sb.append("RobotApplications: ").append(this.getRobotApplications()).append(",");
        }
        if (this.getSimulationApplications() != null) {
            sb.append("SimulationApplications: ").append(this.getSimulationApplications()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJob)) {
            return false;
        }
        SimulationJob other = (SimulationJob)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        if (other.getLastUpdatedAt() != null && !other.getLastUpdatedAt().equals(this.getLastUpdatedAt())) {
            return false;
        }
        if (other.getFailureBehavior() == null ^ this.getFailureBehavior() == null) {
            return false;
        }
        if (other.getFailureBehavior() != null && !other.getFailureBehavior().equals(this.getFailureBehavior())) {
            return false;
        }
        if (other.getFailureCode() == null ^ this.getFailureCode() == null) {
            return false;
        }
        if (other.getFailureCode() != null && !other.getFailureCode().equals(this.getFailureCode())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (other.getOutputLocation() != null && !other.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        if (other.getMaxJobDurationInSeconds() == null ^ this.getMaxJobDurationInSeconds() == null) {
            return false;
        }
        if (other.getMaxJobDurationInSeconds() != null && !other.getMaxJobDurationInSeconds().equals(this.getMaxJobDurationInSeconds())) {
            return false;
        }
        if (other.getSimulationTimeMillis() == null ^ this.getSimulationTimeMillis() == null) {
            return false;
        }
        if (other.getSimulationTimeMillis() != null && !other.getSimulationTimeMillis().equals(this.getSimulationTimeMillis())) {
            return false;
        }
        if (other.getIamRole() == null ^ this.getIamRole() == null) {
            return false;
        }
        if (other.getIamRole() != null && !other.getIamRole().equals(this.getIamRole())) {
            return false;
        }
        if (other.getRobotApplications() == null ^ this.getRobotApplications() == null) {
            return false;
        }
        if (other.getRobotApplications() != null && !other.getRobotApplications().equals(this.getRobotApplications())) {
            return false;
        }
        if (other.getSimulationApplications() == null ^ this.getSimulationApplications() == null) {
            return false;
        }
        if (other.getSimulationApplications() != null && !other.getSimulationApplications().equals(this.getSimulationApplications())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        return other.getVpcConfig() == null || other.getVpcConfig().equals(this.getVpcConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getFailureBehavior() == null ? 0 : this.getFailureBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getFailureCode() == null ? 0 : this.getFailureCode().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getMaxJobDurationInSeconds() == null ? 0 : this.getMaxJobDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getSimulationTimeMillis() == null ? 0 : this.getSimulationTimeMillis().hashCode());
        hashCode = 31 * hashCode + (this.getIamRole() == null ? 0 : this.getIamRole().hashCode());
        hashCode = 31 * hashCode + (this.getRobotApplications() == null ? 0 : this.getRobotApplications().hashCode());
        hashCode = 31 * hashCode + (this.getSimulationApplications() == null ? 0 : this.getSimulationApplications().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        return hashCode;
    }

    public SimulationJob clone() {
        try {
            return (SimulationJob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SimulationJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

