/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resourcegroups.model.GroupConfigurationParameter;
import com.amazonaws.services.resourcegroups.model.transform.GroupConfigurationItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupConfigurationItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private List<GroupConfigurationParameter> parameters;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public GroupConfigurationItem withType(String type) {
        this.setType(type);
        return this;
    }

    public List<GroupConfigurationParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<GroupConfigurationParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<GroupConfigurationParameter>(parameters);
    }

    public GroupConfigurationItem withParameters(GroupConfigurationParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<GroupConfigurationParameter>(parameters.length));
        }
        for (GroupConfigurationParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public GroupConfigurationItem withParameters(Collection<GroupConfigurationParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupConfigurationItem)) {
            return false;
        }
        GroupConfigurationItem other = (GroupConfigurationItem)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public GroupConfigurationItem clone() {
        try {
            return (GroupConfigurationItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupConfigurationItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

