/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resourcegroups.model.FailedResource;
import com.amazonaws.services.resourcegroups.model.PendingResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<String> succeeded;
    private List<FailedResource> failed;
    private List<PendingResource> pending;

    public List<String> getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Collection<String> succeeded) {
        if (succeeded == null) {
            this.succeeded = null;
            return;
        }
        this.succeeded = new ArrayList<String>(succeeded);
    }

    public GroupResourcesResult withSucceeded(String ... succeeded) {
        if (this.succeeded == null) {
            this.setSucceeded(new ArrayList<String>(succeeded.length));
        }
        for (String ele : succeeded) {
            this.succeeded.add(ele);
        }
        return this;
    }

    public GroupResourcesResult withSucceeded(Collection<String> succeeded) {
        this.setSucceeded(succeeded);
        return this;
    }

    public List<FailedResource> getFailed() {
        return this.failed;
    }

    public void setFailed(Collection<FailedResource> failed) {
        if (failed == null) {
            this.failed = null;
            return;
        }
        this.failed = new ArrayList<FailedResource>(failed);
    }

    public GroupResourcesResult withFailed(FailedResource ... failed) {
        if (this.failed == null) {
            this.setFailed(new ArrayList<FailedResource>(failed.length));
        }
        for (FailedResource ele : failed) {
            this.failed.add(ele);
        }
        return this;
    }

    public GroupResourcesResult withFailed(Collection<FailedResource> failed) {
        this.setFailed(failed);
        return this;
    }

    public List<PendingResource> getPending() {
        return this.pending;
    }

    public void setPending(Collection<PendingResource> pending) {
        if (pending == null) {
            this.pending = null;
            return;
        }
        this.pending = new ArrayList<PendingResource>(pending);
    }

    public GroupResourcesResult withPending(PendingResource ... pending) {
        if (this.pending == null) {
            this.setPending(new ArrayList<PendingResource>(pending.length));
        }
        for (PendingResource ele : pending) {
            this.pending.add(ele);
        }
        return this;
    }

    public GroupResourcesResult withPending(Collection<PendingResource> pending) {
        this.setPending(pending);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSucceeded() != null) {
            sb.append("Succeeded: ").append(this.getSucceeded()).append(",");
        }
        if (this.getFailed() != null) {
            sb.append("Failed: ").append(this.getFailed()).append(",");
        }
        if (this.getPending() != null) {
            sb.append("Pending: ").append(this.getPending());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupResourcesResult)) {
            return false;
        }
        GroupResourcesResult other = (GroupResourcesResult)obj;
        if (other.getSucceeded() == null ^ this.getSucceeded() == null) {
            return false;
        }
        if (other.getSucceeded() != null && !other.getSucceeded().equals(this.getSucceeded())) {
            return false;
        }
        if (other.getFailed() == null ^ this.getFailed() == null) {
            return false;
        }
        if (other.getFailed() != null && !other.getFailed().equals(this.getFailed())) {
            return false;
        }
        if (other.getPending() == null ^ this.getPending() == null) {
            return false;
        }
        return other.getPending() == null || other.getPending().equals(this.getPending());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSucceeded() == null ? 0 : this.getSucceeded().hashCode());
        hashCode = 31 * hashCode + (this.getFailed() == null ? 0 : this.getFailed().hashCode());
        hashCode = 31 * hashCode + (this.getPending() == null ? 0 : this.getPending().hashCode());
        return hashCode;
    }

    public GroupResourcesResult clone() {
        try {
            return (GroupResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

