/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.resourceexplorer2.AWSResourceExplorer2Async;
import com.amazonaws.services.resourceexplorer2.AWSResourceExplorer2AsyncClientBuilder;
import com.amazonaws.services.resourceexplorer2.AWSResourceExplorer2Client;
import com.amazonaws.services.resourceexplorer2.model.AssociateDefaultViewRequest;
import com.amazonaws.services.resourceexplorer2.model.AssociateDefaultViewResult;
import com.amazonaws.services.resourceexplorer2.model.BatchGetViewRequest;
import com.amazonaws.services.resourceexplorer2.model.BatchGetViewResult;
import com.amazonaws.services.resourceexplorer2.model.CreateIndexRequest;
import com.amazonaws.services.resourceexplorer2.model.CreateIndexResult;
import com.amazonaws.services.resourceexplorer2.model.CreateViewRequest;
import com.amazonaws.services.resourceexplorer2.model.CreateViewResult;
import com.amazonaws.services.resourceexplorer2.model.DeleteIndexRequest;
import com.amazonaws.services.resourceexplorer2.model.DeleteIndexResult;
import com.amazonaws.services.resourceexplorer2.model.DeleteViewRequest;
import com.amazonaws.services.resourceexplorer2.model.DeleteViewResult;
import com.amazonaws.services.resourceexplorer2.model.DisassociateDefaultViewRequest;
import com.amazonaws.services.resourceexplorer2.model.DisassociateDefaultViewResult;
import com.amazonaws.services.resourceexplorer2.model.GetAccountLevelServiceConfigurationRequest;
import com.amazonaws.services.resourceexplorer2.model.GetAccountLevelServiceConfigurationResult;
import com.amazonaws.services.resourceexplorer2.model.GetDefaultViewRequest;
import com.amazonaws.services.resourceexplorer2.model.GetDefaultViewResult;
import com.amazonaws.services.resourceexplorer2.model.GetIndexRequest;
import com.amazonaws.services.resourceexplorer2.model.GetIndexResult;
import com.amazonaws.services.resourceexplorer2.model.GetViewRequest;
import com.amazonaws.services.resourceexplorer2.model.GetViewResult;
import com.amazonaws.services.resourceexplorer2.model.ListIndexesForMembersRequest;
import com.amazonaws.services.resourceexplorer2.model.ListIndexesForMembersResult;
import com.amazonaws.services.resourceexplorer2.model.ListIndexesRequest;
import com.amazonaws.services.resourceexplorer2.model.ListIndexesResult;
import com.amazonaws.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import com.amazonaws.services.resourceexplorer2.model.ListSupportedResourceTypesResult;
import com.amazonaws.services.resourceexplorer2.model.ListTagsForResourceRequest;
import com.amazonaws.services.resourceexplorer2.model.ListTagsForResourceResult;
import com.amazonaws.services.resourceexplorer2.model.ListViewsRequest;
import com.amazonaws.services.resourceexplorer2.model.ListViewsResult;
import com.amazonaws.services.resourceexplorer2.model.SearchRequest;
import com.amazonaws.services.resourceexplorer2.model.SearchResult;
import com.amazonaws.services.resourceexplorer2.model.TagResourceRequest;
import com.amazonaws.services.resourceexplorer2.model.TagResourceResult;
import com.amazonaws.services.resourceexplorer2.model.UntagResourceRequest;
import com.amazonaws.services.resourceexplorer2.model.UntagResourceResult;
import com.amazonaws.services.resourceexplorer2.model.UpdateIndexTypeRequest;
import com.amazonaws.services.resourceexplorer2.model.UpdateIndexTypeResult;
import com.amazonaws.services.resourceexplorer2.model.UpdateViewRequest;
import com.amazonaws.services.resourceexplorer2.model.UpdateViewResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSResourceExplorer2AsyncClient
extends AWSResourceExplorer2Client
implements AWSResourceExplorer2Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSResourceExplorer2AsyncClientBuilder asyncBuilder() {
        return AWSResourceExplorer2AsyncClientBuilder.standard();
    }

    AWSResourceExplorer2AsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSResourceExplorer2AsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateDefaultViewResult> associateDefaultViewAsync(AssociateDefaultViewRequest request) {
        return this.associateDefaultViewAsync(request, null);
    }

    @Override
    public Future<AssociateDefaultViewResult> associateDefaultViewAsync(AssociateDefaultViewRequest request, final AsyncHandler<AssociateDefaultViewRequest, AssociateDefaultViewResult> asyncHandler) {
        final AssociateDefaultViewRequest finalRequest = (AssociateDefaultViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateDefaultViewResult>(){

            @Override
            public AssociateDefaultViewResult call() throws Exception {
                AssociateDefaultViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeAssociateDefaultView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetViewResult> batchGetViewAsync(BatchGetViewRequest request) {
        return this.batchGetViewAsync(request, null);
    }

    @Override
    public Future<BatchGetViewResult> batchGetViewAsync(BatchGetViewRequest request, final AsyncHandler<BatchGetViewRequest, BatchGetViewResult> asyncHandler) {
        final BatchGetViewRequest finalRequest = (BatchGetViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetViewResult>(){

            @Override
            public BatchGetViewResult call() throws Exception {
                BatchGetViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeBatchGetView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateIndexResult> createIndexAsync(CreateIndexRequest request) {
        return this.createIndexAsync(request, null);
    }

    @Override
    public Future<CreateIndexResult> createIndexAsync(CreateIndexRequest request, final AsyncHandler<CreateIndexRequest, CreateIndexResult> asyncHandler) {
        final CreateIndexRequest finalRequest = (CreateIndexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateIndexResult>(){

            @Override
            public CreateIndexResult call() throws Exception {
                CreateIndexResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeCreateIndex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateViewResult> createViewAsync(CreateViewRequest request) {
        return this.createViewAsync(request, null);
    }

    @Override
    public Future<CreateViewResult> createViewAsync(CreateViewRequest request, final AsyncHandler<CreateViewRequest, CreateViewResult> asyncHandler) {
        final CreateViewRequest finalRequest = (CreateViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateViewResult>(){

            @Override
            public CreateViewResult call() throws Exception {
                CreateViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeCreateView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIndexResult> deleteIndexAsync(DeleteIndexRequest request) {
        return this.deleteIndexAsync(request, null);
    }

    @Override
    public Future<DeleteIndexResult> deleteIndexAsync(DeleteIndexRequest request, final AsyncHandler<DeleteIndexRequest, DeleteIndexResult> asyncHandler) {
        final DeleteIndexRequest finalRequest = (DeleteIndexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteIndexResult>(){

            @Override
            public DeleteIndexResult call() throws Exception {
                DeleteIndexResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeDeleteIndex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteViewResult> deleteViewAsync(DeleteViewRequest request) {
        return this.deleteViewAsync(request, null);
    }

    @Override
    public Future<DeleteViewResult> deleteViewAsync(DeleteViewRequest request, final AsyncHandler<DeleteViewRequest, DeleteViewResult> asyncHandler) {
        final DeleteViewRequest finalRequest = (DeleteViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteViewResult>(){

            @Override
            public DeleteViewResult call() throws Exception {
                DeleteViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeDeleteView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateDefaultViewResult> disassociateDefaultViewAsync(DisassociateDefaultViewRequest request) {
        return this.disassociateDefaultViewAsync(request, null);
    }

    @Override
    public Future<DisassociateDefaultViewResult> disassociateDefaultViewAsync(DisassociateDefaultViewRequest request, final AsyncHandler<DisassociateDefaultViewRequest, DisassociateDefaultViewResult> asyncHandler) {
        final DisassociateDefaultViewRequest finalRequest = (DisassociateDefaultViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateDefaultViewResult>(){

            @Override
            public DisassociateDefaultViewResult call() throws Exception {
                DisassociateDefaultViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeDisassociateDefaultView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountLevelServiceConfigurationResult> getAccountLevelServiceConfigurationAsync(GetAccountLevelServiceConfigurationRequest request) {
        return this.getAccountLevelServiceConfigurationAsync(request, null);
    }

    @Override
    public Future<GetAccountLevelServiceConfigurationResult> getAccountLevelServiceConfigurationAsync(GetAccountLevelServiceConfigurationRequest request, final AsyncHandler<GetAccountLevelServiceConfigurationRequest, GetAccountLevelServiceConfigurationResult> asyncHandler) {
        final GetAccountLevelServiceConfigurationRequest finalRequest = (GetAccountLevelServiceConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountLevelServiceConfigurationResult>(){

            @Override
            public GetAccountLevelServiceConfigurationResult call() throws Exception {
                GetAccountLevelServiceConfigurationResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeGetAccountLevelServiceConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDefaultViewResult> getDefaultViewAsync(GetDefaultViewRequest request) {
        return this.getDefaultViewAsync(request, null);
    }

    @Override
    public Future<GetDefaultViewResult> getDefaultViewAsync(GetDefaultViewRequest request, final AsyncHandler<GetDefaultViewRequest, GetDefaultViewResult> asyncHandler) {
        final GetDefaultViewRequest finalRequest = (GetDefaultViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDefaultViewResult>(){

            @Override
            public GetDefaultViewResult call() throws Exception {
                GetDefaultViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeGetDefaultView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIndexResult> getIndexAsync(GetIndexRequest request) {
        return this.getIndexAsync(request, null);
    }

    @Override
    public Future<GetIndexResult> getIndexAsync(GetIndexRequest request, final AsyncHandler<GetIndexRequest, GetIndexResult> asyncHandler) {
        final GetIndexRequest finalRequest = (GetIndexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIndexResult>(){

            @Override
            public GetIndexResult call() throws Exception {
                GetIndexResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeGetIndex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetViewResult> getViewAsync(GetViewRequest request) {
        return this.getViewAsync(request, null);
    }

    @Override
    public Future<GetViewResult> getViewAsync(GetViewRequest request, final AsyncHandler<GetViewRequest, GetViewResult> asyncHandler) {
        final GetViewRequest finalRequest = (GetViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetViewResult>(){

            @Override
            public GetViewResult call() throws Exception {
                GetViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeGetView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIndexesResult> listIndexesAsync(ListIndexesRequest request) {
        return this.listIndexesAsync(request, null);
    }

    @Override
    public Future<ListIndexesResult> listIndexesAsync(ListIndexesRequest request, final AsyncHandler<ListIndexesRequest, ListIndexesResult> asyncHandler) {
        final ListIndexesRequest finalRequest = (ListIndexesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIndexesResult>(){

            @Override
            public ListIndexesResult call() throws Exception {
                ListIndexesResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeListIndexes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIndexesForMembersResult> listIndexesForMembersAsync(ListIndexesForMembersRequest request) {
        return this.listIndexesForMembersAsync(request, null);
    }

    @Override
    public Future<ListIndexesForMembersResult> listIndexesForMembersAsync(ListIndexesForMembersRequest request, final AsyncHandler<ListIndexesForMembersRequest, ListIndexesForMembersResult> asyncHandler) {
        final ListIndexesForMembersRequest finalRequest = (ListIndexesForMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIndexesForMembersResult>(){

            @Override
            public ListIndexesForMembersResult call() throws Exception {
                ListIndexesForMembersResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeListIndexesForMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSupportedResourceTypesResult> listSupportedResourceTypesAsync(ListSupportedResourceTypesRequest request) {
        return this.listSupportedResourceTypesAsync(request, null);
    }

    @Override
    public Future<ListSupportedResourceTypesResult> listSupportedResourceTypesAsync(ListSupportedResourceTypesRequest request, final AsyncHandler<ListSupportedResourceTypesRequest, ListSupportedResourceTypesResult> asyncHandler) {
        final ListSupportedResourceTypesRequest finalRequest = (ListSupportedResourceTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSupportedResourceTypesResult>(){

            @Override
            public ListSupportedResourceTypesResult call() throws Exception {
                ListSupportedResourceTypesResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeListSupportedResourceTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListViewsResult> listViewsAsync(ListViewsRequest request) {
        return this.listViewsAsync(request, null);
    }

    @Override
    public Future<ListViewsResult> listViewsAsync(ListViewsRequest request, final AsyncHandler<ListViewsRequest, ListViewsResult> asyncHandler) {
        final ListViewsRequest finalRequest = (ListViewsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListViewsResult>(){

            @Override
            public ListViewsResult call() throws Exception {
                ListViewsResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeListViews(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchResult> searchAsync(SearchRequest request) {
        return this.searchAsync(request, null);
    }

    @Override
    public Future<SearchResult> searchAsync(SearchRequest request, final AsyncHandler<SearchRequest, SearchResult> asyncHandler) {
        final SearchRequest finalRequest = (SearchRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchResult>(){

            @Override
            public SearchResult call() throws Exception {
                SearchResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeSearch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateIndexTypeResult> updateIndexTypeAsync(UpdateIndexTypeRequest request) {
        return this.updateIndexTypeAsync(request, null);
    }

    @Override
    public Future<UpdateIndexTypeResult> updateIndexTypeAsync(UpdateIndexTypeRequest request, final AsyncHandler<UpdateIndexTypeRequest, UpdateIndexTypeResult> asyncHandler) {
        final UpdateIndexTypeRequest finalRequest = (UpdateIndexTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateIndexTypeResult>(){

            @Override
            public UpdateIndexTypeResult call() throws Exception {
                UpdateIndexTypeResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeUpdateIndexType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateViewResult> updateViewAsync(UpdateViewRequest request) {
        return this.updateViewAsync(request, null);
    }

    @Override
    public Future<UpdateViewResult> updateViewAsync(UpdateViewRequest request, final AsyncHandler<UpdateViewRequest, UpdateViewResult> asyncHandler) {
        final UpdateViewRequest finalRequest = (UpdateViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateViewResult>(){

            @Override
            public UpdateViewResult call() throws Exception {
                UpdateViewResult result = null;
                try {
                    result = AWSResourceExplorer2AsyncClient.this.executeUpdateView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

