/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourceexplorer2;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.resourceexplorer2.AWSResourceExplorer2;
import com.amazonaws.services.resourceexplorer2.AWSResourceExplorer2ClientBuilder;
import com.amazonaws.services.resourceexplorer2.model.AWSResourceExplorer2Exception;
import com.amazonaws.services.resourceexplorer2.model.AssociateDefaultViewRequest;
import com.amazonaws.services.resourceexplorer2.model.AssociateDefaultViewResult;
import com.amazonaws.services.resourceexplorer2.model.BatchGetViewRequest;
import com.amazonaws.services.resourceexplorer2.model.BatchGetViewResult;
import com.amazonaws.services.resourceexplorer2.model.CreateIndexRequest;
import com.amazonaws.services.resourceexplorer2.model.CreateIndexResult;
import com.amazonaws.services.resourceexplorer2.model.CreateViewRequest;
import com.amazonaws.services.resourceexplorer2.model.CreateViewResult;
import com.amazonaws.services.resourceexplorer2.model.DeleteIndexRequest;
import com.amazonaws.services.resourceexplorer2.model.DeleteIndexResult;
import com.amazonaws.services.resourceexplorer2.model.DeleteViewRequest;
import com.amazonaws.services.resourceexplorer2.model.DeleteViewResult;
import com.amazonaws.services.resourceexplorer2.model.DisassociateDefaultViewRequest;
import com.amazonaws.services.resourceexplorer2.model.DisassociateDefaultViewResult;
import com.amazonaws.services.resourceexplorer2.model.GetDefaultViewRequest;
import com.amazonaws.services.resourceexplorer2.model.GetDefaultViewResult;
import com.amazonaws.services.resourceexplorer2.model.GetIndexRequest;
import com.amazonaws.services.resourceexplorer2.model.GetIndexResult;
import com.amazonaws.services.resourceexplorer2.model.GetViewRequest;
import com.amazonaws.services.resourceexplorer2.model.GetViewResult;
import com.amazonaws.services.resourceexplorer2.model.ListIndexesRequest;
import com.amazonaws.services.resourceexplorer2.model.ListIndexesResult;
import com.amazonaws.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import com.amazonaws.services.resourceexplorer2.model.ListSupportedResourceTypesResult;
import com.amazonaws.services.resourceexplorer2.model.ListTagsForResourceRequest;
import com.amazonaws.services.resourceexplorer2.model.ListTagsForResourceResult;
import com.amazonaws.services.resourceexplorer2.model.ListViewsRequest;
import com.amazonaws.services.resourceexplorer2.model.ListViewsResult;
import com.amazonaws.services.resourceexplorer2.model.SearchRequest;
import com.amazonaws.services.resourceexplorer2.model.SearchResult;
import com.amazonaws.services.resourceexplorer2.model.TagResourceRequest;
import com.amazonaws.services.resourceexplorer2.model.TagResourceResult;
import com.amazonaws.services.resourceexplorer2.model.UntagResourceRequest;
import com.amazonaws.services.resourceexplorer2.model.UntagResourceResult;
import com.amazonaws.services.resourceexplorer2.model.UpdateIndexTypeRequest;
import com.amazonaws.services.resourceexplorer2.model.UpdateIndexTypeResult;
import com.amazonaws.services.resourceexplorer2.model.UpdateViewRequest;
import com.amazonaws.services.resourceexplorer2.model.UpdateViewResult;
import com.amazonaws.services.resourceexplorer2.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.AssociateDefaultViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.AssociateDefaultViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.BatchGetViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.BatchGetViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.CreateIndexRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.CreateIndexResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.CreateViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.CreateViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.DeleteIndexRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.DeleteIndexResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.DeleteViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.DeleteViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.DisassociateDefaultViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.DisassociateDefaultViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.GetDefaultViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.GetDefaultViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.GetIndexRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.GetIndexResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.GetViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.GetViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListIndexesRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListIndexesResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListSupportedResourceTypesRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListSupportedResourceTypesResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListViewsRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ListViewsResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.SearchRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.SearchResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.UnauthorizedExceptionUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.UpdateIndexTypeRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.UpdateIndexTypeResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.UpdateViewRequestProtocolMarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.UpdateViewResultJsonUnmarshaller;
import com.amazonaws.services.resourceexplorer2.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSResourceExplorer2Client
extends AmazonWebServiceClient
implements AWSResourceExplorer2 {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSResourceExplorer2.class);
    private static final String DEFAULT_SIGNING_NAME = "resource-explorer-2";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSResourceExplorer2Exception.class));

    public static AWSResourceExplorer2ClientBuilder builder() {
        return AWSResourceExplorer2ClientBuilder.standard();
    }

    AWSResourceExplorer2Client(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSResourceExplorer2Client(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("resource-explorer-2.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/resourceexplorer2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/resourceexplorer2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateDefaultViewResult associateDefaultView(AssociateDefaultViewRequest request) {
        request = (AssociateDefaultViewRequest)this.beforeClientExecution(request);
        return this.executeAssociateDefaultView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateDefaultViewResult executeAssociateDefaultView(AssociateDefaultViewRequest associateDefaultViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateDefaultViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateDefaultViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateDefaultViewRequestProtocolMarshaller(protocolFactory).marshall((AssociateDefaultViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateDefaultViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateDefaultView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateDefaultViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateDefaultViewResult associateDefaultViewResult = (AssociateDefaultViewResult)response.getAwsResponse();
            return associateDefaultViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetViewResult batchGetView(BatchGetViewRequest request) {
        request = (BatchGetViewRequest)this.beforeClientExecution(request);
        return this.executeBatchGetView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetViewResult executeBatchGetView(BatchGetViewRequest batchGetViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetViewRequestProtocolMarshaller(protocolFactory).marshall((BatchGetViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetViewResult batchGetViewResult = (BatchGetViewResult)response.getAwsResponse();
            return batchGetViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateIndexResult createIndex(CreateIndexRequest request) {
        request = (CreateIndexRequest)this.beforeClientExecution(request);
        return this.executeCreateIndex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateIndexResult executeCreateIndex(CreateIndexRequest createIndexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createIndexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateIndexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateIndexRequestProtocolMarshaller(protocolFactory).marshall((CreateIndexRequest)super.beforeMarshalling((AmazonWebServiceRequest)createIndexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateIndex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateIndexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateIndexResult createIndexResult = (CreateIndexResult)response.getAwsResponse();
            return createIndexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateViewResult createView(CreateViewRequest request) {
        request = (CreateViewRequest)this.beforeClientExecution(request);
        return this.executeCreateView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateViewResult executeCreateView(CreateViewRequest createViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateViewRequestProtocolMarshaller(protocolFactory).marshall((CreateViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)createViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateViewResult createViewResult = (CreateViewResult)response.getAwsResponse();
            return createViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteIndexResult deleteIndex(DeleteIndexRequest request) {
        request = (DeleteIndexRequest)this.beforeClientExecution(request);
        return this.executeDeleteIndex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteIndexResult executeDeleteIndex(DeleteIndexRequest deleteIndexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIndexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIndexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIndexRequestProtocolMarshaller(protocolFactory).marshall((DeleteIndexRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIndexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteIndex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteIndexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteIndexResult deleteIndexResult = (DeleteIndexResult)response.getAwsResponse();
            return deleteIndexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteViewResult deleteView(DeleteViewRequest request) {
        request = (DeleteViewRequest)this.beforeClientExecution(request);
        return this.executeDeleteView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteViewResult executeDeleteView(DeleteViewRequest deleteViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteViewRequestProtocolMarshaller(protocolFactory).marshall((DeleteViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteViewResult deleteViewResult = (DeleteViewResult)response.getAwsResponse();
            return deleteViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateDefaultViewResult disassociateDefaultView(DisassociateDefaultViewRequest request) {
        request = (DisassociateDefaultViewRequest)this.beforeClientExecution(request);
        return this.executeDisassociateDefaultView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateDefaultViewResult executeDisassociateDefaultView(DisassociateDefaultViewRequest disassociateDefaultViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateDefaultViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateDefaultViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateDefaultViewRequestProtocolMarshaller(protocolFactory).marshall((DisassociateDefaultViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateDefaultViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateDefaultView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateDefaultViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateDefaultViewResult disassociateDefaultViewResult = (DisassociateDefaultViewResult)response.getAwsResponse();
            return disassociateDefaultViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDefaultViewResult getDefaultView(GetDefaultViewRequest request) {
        request = (GetDefaultViewRequest)this.beforeClientExecution(request);
        return this.executeGetDefaultView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDefaultViewResult executeGetDefaultView(GetDefaultViewRequest getDefaultViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDefaultViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDefaultViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDefaultViewRequestProtocolMarshaller(protocolFactory).marshall((GetDefaultViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDefaultViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDefaultView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDefaultViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDefaultViewResult getDefaultViewResult = (GetDefaultViewResult)response.getAwsResponse();
            return getDefaultViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetIndexResult getIndex(GetIndexRequest request) {
        request = (GetIndexRequest)this.beforeClientExecution(request);
        return this.executeGetIndex(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIndexResult executeGetIndex(GetIndexRequest getIndexRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIndexRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIndexRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIndexRequestProtocolMarshaller(protocolFactory).marshall((GetIndexRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIndexRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetIndex");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIndexResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIndexResult getIndexResult = (GetIndexResult)response.getAwsResponse();
            return getIndexResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetViewResult getView(GetViewRequest request) {
        request = (GetViewRequest)this.beforeClientExecution(request);
        return this.executeGetView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetViewResult executeGetView(GetViewRequest getViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetViewRequestProtocolMarshaller(protocolFactory).marshall((GetViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)getViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetViewResult getViewResult = (GetViewResult)response.getAwsResponse();
            return getViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListIndexesResult listIndexes(ListIndexesRequest request) {
        request = (ListIndexesRequest)this.beforeClientExecution(request);
        return this.executeListIndexes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListIndexesResult executeListIndexes(ListIndexesRequest listIndexesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIndexesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIndexesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIndexesRequestProtocolMarshaller(protocolFactory).marshall((ListIndexesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIndexesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListIndexes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIndexesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListIndexesResult listIndexesResult = (ListIndexesResult)response.getAwsResponse();
            return listIndexesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSupportedResourceTypesResult listSupportedResourceTypes(ListSupportedResourceTypesRequest request) {
        request = (ListSupportedResourceTypesRequest)this.beforeClientExecution(request);
        return this.executeListSupportedResourceTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSupportedResourceTypesResult executeListSupportedResourceTypes(ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSupportedResourceTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSupportedResourceTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSupportedResourceTypesRequestProtocolMarshaller(protocolFactory).marshall((ListSupportedResourceTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSupportedResourceTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSupportedResourceTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSupportedResourceTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSupportedResourceTypesResult listSupportedResourceTypesResult = (ListSupportedResourceTypesResult)response.getAwsResponse();
            return listSupportedResourceTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListViewsResult listViews(ListViewsRequest request) {
        request = (ListViewsRequest)this.beforeClientExecution(request);
        return this.executeListViews(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListViewsResult executeListViews(ListViewsRequest listViewsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listViewsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListViewsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListViewsRequestProtocolMarshaller(protocolFactory).marshall((ListViewsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listViewsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListViews");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListViewsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListViewsResult listViewsResult = (ListViewsResult)response.getAwsResponse();
            return listViewsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SearchResult search(SearchRequest request) {
        request = (SearchRequest)this.beforeClientExecution(request);
        return this.executeSearch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SearchResult executeSearch(SearchRequest searchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(searchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SearchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SearchRequestProtocolMarshaller(protocolFactory).marshall((SearchRequest)super.beforeMarshalling((AmazonWebServiceRequest)searchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Search");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SearchResult searchResult = (SearchResult)response.getAwsResponse();
            return searchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateIndexTypeResult updateIndexType(UpdateIndexTypeRequest request) {
        request = (UpdateIndexTypeRequest)this.beforeClientExecution(request);
        return this.executeUpdateIndexType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateIndexTypeResult executeUpdateIndexType(UpdateIndexTypeRequest updateIndexTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateIndexTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateIndexTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateIndexTypeRequestProtocolMarshaller(protocolFactory).marshall((UpdateIndexTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateIndexTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateIndexType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateIndexTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateIndexTypeResult updateIndexTypeResult = (UpdateIndexTypeResult)response.getAwsResponse();
            return updateIndexTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateViewResult updateView(UpdateViewRequest request) {
        request = (UpdateViewRequest)this.beforeClientExecution(request);
        return this.executeUpdateView(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateViewResult executeUpdateView(UpdateViewRequest updateViewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateViewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateViewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateViewRequestProtocolMarshaller(protocolFactory).marshall((UpdateViewRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateViewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Resource Explorer 2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateView");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateViewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateViewResult updateViewResult = (UpdateViewResult)response.getAwsResponse();
            return updateViewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

