/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resiliencehub.model.AppSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAppsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AppSummary> appSummaries;
    private String nextToken;

    public List<AppSummary> getAppSummaries() {
        return this.appSummaries;
    }

    public void setAppSummaries(Collection<AppSummary> appSummaries) {
        if (appSummaries == null) {
            this.appSummaries = null;
            return;
        }
        this.appSummaries = new ArrayList<AppSummary>(appSummaries);
    }

    public ListAppsResult withAppSummaries(AppSummary ... appSummaries) {
        if (this.appSummaries == null) {
            this.setAppSummaries(new ArrayList<AppSummary>(appSummaries.length));
        }
        for (AppSummary ele : appSummaries) {
            this.appSummaries.add(ele);
        }
        return this;
    }

    public ListAppsResult withAppSummaries(Collection<AppSummary> appSummaries) {
        this.setAppSummaries(appSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAppsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppSummaries() != null) {
            sb.append("AppSummaries: ").append(this.getAppSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResult)) {
            return false;
        }
        ListAppsResult other = (ListAppsResult)obj;
        if (other.getAppSummaries() == null ^ this.getAppSummaries() == null) {
            return false;
        }
        if (other.getAppSummaries() != null && !other.getAppSummaries().equals(this.getAppSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppSummaries() == null ? 0 : this.getAppSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAppsResult clone() {
        try {
            return (ListAppsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

