/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.ComplianceStatus;
import com.amazonaws.services.resiliencehub.model.Cost;
import com.amazonaws.services.resiliencehub.model.DisruptionCompliance;
import com.amazonaws.services.resiliencehub.model.ResiliencyScore;
import com.amazonaws.services.resiliencehub.model.transform.AppComponentComplianceMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AppComponentCompliance
implements Serializable,
Cloneable,
StructuredPojo {
    private String appComponentName;
    private Map<String, DisruptionCompliance> compliance;
    private Cost cost;
    private String message;
    private ResiliencyScore resiliencyScore;
    private String status;

    public void setAppComponentName(String appComponentName) {
        this.appComponentName = appComponentName;
    }

    public String getAppComponentName() {
        return this.appComponentName;
    }

    public AppComponentCompliance withAppComponentName(String appComponentName) {
        this.setAppComponentName(appComponentName);
        return this;
    }

    public Map<String, DisruptionCompliance> getCompliance() {
        return this.compliance;
    }

    public void setCompliance(Map<String, DisruptionCompliance> compliance) {
        this.compliance = compliance;
    }

    public AppComponentCompliance withCompliance(Map<String, DisruptionCompliance> compliance) {
        this.setCompliance(compliance);
        return this;
    }

    public AppComponentCompliance addComplianceEntry(String key, DisruptionCompliance value) {
        if (null == this.compliance) {
            this.compliance = new HashMap<String, DisruptionCompliance>();
        }
        if (this.compliance.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.compliance.put(key, value);
        return this;
    }

    public AppComponentCompliance clearComplianceEntries() {
        this.compliance = null;
        return this;
    }

    public void setCost(Cost cost) {
        this.cost = cost;
    }

    public Cost getCost() {
        return this.cost;
    }

    public AppComponentCompliance withCost(Cost cost) {
        this.setCost(cost);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public AppComponentCompliance withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setResiliencyScore(ResiliencyScore resiliencyScore) {
        this.resiliencyScore = resiliencyScore;
    }

    public ResiliencyScore getResiliencyScore() {
        return this.resiliencyScore;
    }

    public AppComponentCompliance withResiliencyScore(ResiliencyScore resiliencyScore) {
        this.setResiliencyScore(resiliencyScore);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AppComponentCompliance withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public AppComponentCompliance withStatus(ComplianceStatus status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppComponentName() != null) {
            sb.append("AppComponentName: ").append(this.getAppComponentName()).append(",");
        }
        if (this.getCompliance() != null) {
            sb.append("Compliance: ").append(this.getCompliance()).append(",");
        }
        if (this.getCost() != null) {
            sb.append("Cost: ").append(this.getCost()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getResiliencyScore() != null) {
            sb.append("ResiliencyScore: ").append(this.getResiliencyScore()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppComponentCompliance)) {
            return false;
        }
        AppComponentCompliance other = (AppComponentCompliance)obj;
        if (other.getAppComponentName() == null ^ this.getAppComponentName() == null) {
            return false;
        }
        if (other.getAppComponentName() != null && !other.getAppComponentName().equals(this.getAppComponentName())) {
            return false;
        }
        if (other.getCompliance() == null ^ this.getCompliance() == null) {
            return false;
        }
        if (other.getCompliance() != null && !other.getCompliance().equals(this.getCompliance())) {
            return false;
        }
        if (other.getCost() == null ^ this.getCost() == null) {
            return false;
        }
        if (other.getCost() != null && !other.getCost().equals(this.getCost())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getResiliencyScore() == null ^ this.getResiliencyScore() == null) {
            return false;
        }
        if (other.getResiliencyScore() != null && !other.getResiliencyScore().equals(this.getResiliencyScore())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppComponentName() == null ? 0 : this.getAppComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getCompliance() == null ? 0 : this.getCompliance().hashCode());
        hashCode = 31 * hashCode + (this.getCost() == null ? 0 : this.getCost().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getResiliencyScore() == null ? 0 : this.getResiliencyScore().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public AppComponentCompliance clone() {
        try {
            return (AppComponentCompliance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppComponentComplianceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

