/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.resiliencehub.model.App;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class AppMarshaller {
    private static final MarshallingInfo<String> APPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appArn").build();
    private static final MarshallingInfo<String> ASSESSMENTSCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assessmentSchedule").build();
    private static final MarshallingInfo<String> COMPLIANCESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("complianceStatus").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Date> LASTAPPCOMPLIANCEEVALUATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastAppComplianceEvaluationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTRESILIENCYSCOREEVALUATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastResiliencyScoreEvaluationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> POLICYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyArn").build();
    private static final MarshallingInfo<Double> RESILIENCYSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resiliencyScore").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final AppMarshaller instance = new AppMarshaller();

    public static AppMarshaller getInstance() {
        return instance;
    }

    public void marshall(App app, ProtocolMarshaller protocolMarshaller) {
        if (app == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)app.getAppArn(), APPARN_BINDING);
            protocolMarshaller.marshall((Object)app.getAssessmentSchedule(), ASSESSMENTSCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)app.getComplianceStatus(), COMPLIANCESTATUS_BINDING);
            protocolMarshaller.marshall((Object)app.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)app.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)app.getLastAppComplianceEvaluationTime(), LASTAPPCOMPLIANCEEVALUATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)app.getLastResiliencyScoreEvaluationTime(), LASTRESILIENCYSCOREEVALUATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)app.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)app.getPolicyArn(), POLICYARN_BINDING);
            protocolMarshaller.marshall((Object)app.getResiliencyScore(), RESILIENCYSCORE_BINDING);
            protocolMarshaller.marshall((Object)app.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(app.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

