/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resiliencehub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.resiliencehub.model.ConfigRecommendationOptimizationType;
import com.amazonaws.services.resiliencehub.model.Cost;
import com.amazonaws.services.resiliencehub.model.DisruptionCompliance;
import com.amazonaws.services.resiliencehub.model.HaArchitecture;
import com.amazonaws.services.resiliencehub.model.RecommendationDisruptionCompliance;
import com.amazonaws.services.resiliencehub.model.transform.ConfigRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String appComponentName;
    private Map<String, DisruptionCompliance> compliance;
    private Cost cost;
    private String description;
    private String haArchitecture;
    private String name;
    private String optimizationType;
    private Map<String, RecommendationDisruptionCompliance> recommendationCompliance;
    private String referenceId;
    private List<String> suggestedChanges;

    public void setAppComponentName(String appComponentName) {
        this.appComponentName = appComponentName;
    }

    public String getAppComponentName() {
        return this.appComponentName;
    }

    public ConfigRecommendation withAppComponentName(String appComponentName) {
        this.setAppComponentName(appComponentName);
        return this;
    }

    public Map<String, DisruptionCompliance> getCompliance() {
        return this.compliance;
    }

    public void setCompliance(Map<String, DisruptionCompliance> compliance) {
        this.compliance = compliance;
    }

    public ConfigRecommendation withCompliance(Map<String, DisruptionCompliance> compliance) {
        this.setCompliance(compliance);
        return this;
    }

    public ConfigRecommendation addComplianceEntry(String key, DisruptionCompliance value) {
        if (null == this.compliance) {
            this.compliance = new HashMap<String, DisruptionCompliance>();
        }
        if (this.compliance.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.compliance.put(key, value);
        return this;
    }

    public ConfigRecommendation clearComplianceEntries() {
        this.compliance = null;
        return this;
    }

    public void setCost(Cost cost) {
        this.cost = cost;
    }

    public Cost getCost() {
        return this.cost;
    }

    public ConfigRecommendation withCost(Cost cost) {
        this.setCost(cost);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigRecommendation withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setHaArchitecture(String haArchitecture) {
        this.haArchitecture = haArchitecture;
    }

    public String getHaArchitecture() {
        return this.haArchitecture;
    }

    public ConfigRecommendation withHaArchitecture(String haArchitecture) {
        this.setHaArchitecture(haArchitecture);
        return this;
    }

    public ConfigRecommendation withHaArchitecture(HaArchitecture haArchitecture) {
        this.haArchitecture = haArchitecture.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ConfigRecommendation withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOptimizationType(String optimizationType) {
        this.optimizationType = optimizationType;
    }

    public String getOptimizationType() {
        return this.optimizationType;
    }

    public ConfigRecommendation withOptimizationType(String optimizationType) {
        this.setOptimizationType(optimizationType);
        return this;
    }

    public ConfigRecommendation withOptimizationType(ConfigRecommendationOptimizationType optimizationType) {
        this.optimizationType = optimizationType.toString();
        return this;
    }

    public Map<String, RecommendationDisruptionCompliance> getRecommendationCompliance() {
        return this.recommendationCompliance;
    }

    public void setRecommendationCompliance(Map<String, RecommendationDisruptionCompliance> recommendationCompliance) {
        this.recommendationCompliance = recommendationCompliance;
    }

    public ConfigRecommendation withRecommendationCompliance(Map<String, RecommendationDisruptionCompliance> recommendationCompliance) {
        this.setRecommendationCompliance(recommendationCompliance);
        return this;
    }

    public ConfigRecommendation addRecommendationComplianceEntry(String key, RecommendationDisruptionCompliance value) {
        if (null == this.recommendationCompliance) {
            this.recommendationCompliance = new HashMap<String, RecommendationDisruptionCompliance>();
        }
        if (this.recommendationCompliance.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.recommendationCompliance.put(key, value);
        return this;
    }

    public ConfigRecommendation clearRecommendationComplianceEntries() {
        this.recommendationCompliance = null;
        return this;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public ConfigRecommendation withReferenceId(String referenceId) {
        this.setReferenceId(referenceId);
        return this;
    }

    public List<String> getSuggestedChanges() {
        return this.suggestedChanges;
    }

    public void setSuggestedChanges(Collection<String> suggestedChanges) {
        if (suggestedChanges == null) {
            this.suggestedChanges = null;
            return;
        }
        this.suggestedChanges = new ArrayList<String>(suggestedChanges);
    }

    public ConfigRecommendation withSuggestedChanges(String ... suggestedChanges) {
        if (this.suggestedChanges == null) {
            this.setSuggestedChanges(new ArrayList<String>(suggestedChanges.length));
        }
        for (String ele : suggestedChanges) {
            this.suggestedChanges.add(ele);
        }
        return this;
    }

    public ConfigRecommendation withSuggestedChanges(Collection<String> suggestedChanges) {
        this.setSuggestedChanges(suggestedChanges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppComponentName() != null) {
            sb.append("AppComponentName: ").append(this.getAppComponentName()).append(",");
        }
        if (this.getCompliance() != null) {
            sb.append("Compliance: ").append(this.getCompliance()).append(",");
        }
        if (this.getCost() != null) {
            sb.append("Cost: ").append(this.getCost()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getHaArchitecture() != null) {
            sb.append("HaArchitecture: ").append(this.getHaArchitecture()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOptimizationType() != null) {
            sb.append("OptimizationType: ").append(this.getOptimizationType()).append(",");
        }
        if (this.getRecommendationCompliance() != null) {
            sb.append("RecommendationCompliance: ").append(this.getRecommendationCompliance()).append(",");
        }
        if (this.getReferenceId() != null) {
            sb.append("ReferenceId: ").append(this.getReferenceId()).append(",");
        }
        if (this.getSuggestedChanges() != null) {
            sb.append("SuggestedChanges: ").append(this.getSuggestedChanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRecommendation)) {
            return false;
        }
        ConfigRecommendation other = (ConfigRecommendation)obj;
        if (other.getAppComponentName() == null ^ this.getAppComponentName() == null) {
            return false;
        }
        if (other.getAppComponentName() != null && !other.getAppComponentName().equals(this.getAppComponentName())) {
            return false;
        }
        if (other.getCompliance() == null ^ this.getCompliance() == null) {
            return false;
        }
        if (other.getCompliance() != null && !other.getCompliance().equals(this.getCompliance())) {
            return false;
        }
        if (other.getCost() == null ^ this.getCost() == null) {
            return false;
        }
        if (other.getCost() != null && !other.getCost().equals(this.getCost())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getHaArchitecture() == null ^ this.getHaArchitecture() == null) {
            return false;
        }
        if (other.getHaArchitecture() != null && !other.getHaArchitecture().equals(this.getHaArchitecture())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOptimizationType() == null ^ this.getOptimizationType() == null) {
            return false;
        }
        if (other.getOptimizationType() != null && !other.getOptimizationType().equals(this.getOptimizationType())) {
            return false;
        }
        if (other.getRecommendationCompliance() == null ^ this.getRecommendationCompliance() == null) {
            return false;
        }
        if (other.getRecommendationCompliance() != null && !other.getRecommendationCompliance().equals(this.getRecommendationCompliance())) {
            return false;
        }
        if (other.getReferenceId() == null ^ this.getReferenceId() == null) {
            return false;
        }
        if (other.getReferenceId() != null && !other.getReferenceId().equals(this.getReferenceId())) {
            return false;
        }
        if (other.getSuggestedChanges() == null ^ this.getSuggestedChanges() == null) {
            return false;
        }
        return other.getSuggestedChanges() == null || other.getSuggestedChanges().equals(this.getSuggestedChanges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppComponentName() == null ? 0 : this.getAppComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getCompliance() == null ? 0 : this.getCompliance().hashCode());
        hashCode = 31 * hashCode + (this.getCost() == null ? 0 : this.getCost().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getHaArchitecture() == null ? 0 : this.getHaArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOptimizationType() == null ? 0 : this.getOptimizationType().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationCompliance() == null ? 0 : this.getRecommendationCompliance().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceId() == null ? 0 : this.getReferenceId().hashCode());
        hashCode = 31 * hashCode + (this.getSuggestedChanges() == null ? 0 : this.getSuggestedChanges().hashCode());
        return hashCode;
    }

    public ConfigRecommendation clone() {
        try {
            return (ConfigRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

