/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.rekognition.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.rekognition.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SegmentDetection JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SegmentDetectionJsonUnmarshaller implements Unmarshaller<SegmentDetection, JsonUnmarshallerContext> {

    public SegmentDetection unmarshall(JsonUnmarshallerContext context) throws Exception {
        SegmentDetection segmentDetection = new SegmentDetection();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StartTimestampMillis", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setStartTimestampMillis(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("EndTimestampMillis", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setEndTimestampMillis(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("DurationMillis", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setDurationMillis(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("StartTimecodeSMPTE", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setStartTimecodeSMPTE(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EndTimecodeSMPTE", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setEndTimecodeSMPTE(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DurationSMPTE", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setDurationSMPTE(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TechnicalCueSegment", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setTechnicalCueSegment(TechnicalCueSegmentJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ShotSegment", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setShotSegment(ShotSegmentJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("StartFrameNumber", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setStartFrameNumber(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("EndFrameNumber", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setEndFrameNumber(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("DurationFrames", targetDepth)) {
                    context.nextToken();
                    segmentDetection.setDurationFrames(context.getUnmarshaller(Long.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return segmentDetection;
    }

    private static SegmentDetectionJsonUnmarshaller instance;

    public static SegmentDetectionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new SegmentDetectionJsonUnmarshaller();
        return instance;
    }
}
