/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.DetectLabelsFeatureName;
import com.amazonaws.services.rekognition.model.DetectLabelsSettings;
import com.amazonaws.services.rekognition.model.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectLabelsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Image image;
    private Integer maxLabels;
    private Float minConfidence;
    private List<String> features;
    private DetectLabelsSettings settings;

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public DetectLabelsRequest withImage(Image image) {
        this.setImage(image);
        return this;
    }

    public void setMaxLabels(Integer maxLabels) {
        this.maxLabels = maxLabels;
    }

    public Integer getMaxLabels() {
        return this.maxLabels;
    }

    public DetectLabelsRequest withMaxLabels(Integer maxLabels) {
        this.setMaxLabels(maxLabels);
        return this;
    }

    public void setMinConfidence(Float minConfidence) {
        this.minConfidence = minConfidence;
    }

    public Float getMinConfidence() {
        return this.minConfidence;
    }

    public DetectLabelsRequest withMinConfidence(Float minConfidence) {
        this.setMinConfidence(minConfidence);
        return this;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<String> features) {
        if (features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<String>(features);
    }

    public DetectLabelsRequest withFeatures(String ... features) {
        if (this.features == null) {
            this.setFeatures(new ArrayList<String>(features.length));
        }
        for (String ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    public DetectLabelsRequest withFeatures(Collection<String> features) {
        this.setFeatures(features);
        return this;
    }

    public DetectLabelsRequest withFeatures(DetectLabelsFeatureName ... features) {
        ArrayList<String> featuresCopy = new ArrayList<String>(features.length);
        for (DetectLabelsFeatureName value : features) {
            featuresCopy.add(value.toString());
        }
        if (this.getFeatures() == null) {
            this.setFeatures(featuresCopy);
        } else {
            this.getFeatures().addAll(featuresCopy);
        }
        return this;
    }

    public void setSettings(DetectLabelsSettings settings) {
        this.settings = settings;
    }

    public DetectLabelsSettings getSettings() {
        return this.settings;
    }

    public DetectLabelsRequest withSettings(DetectLabelsSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getMaxLabels() != null) {
            sb.append("MaxLabels: ").append(this.getMaxLabels()).append(",");
        }
        if (this.getMinConfidence() != null) {
            sb.append("MinConfidence: ").append(this.getMinConfidence()).append(",");
        }
        if (this.getFeatures() != null) {
            sb.append("Features: ").append(this.getFeatures()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsRequest)) {
            return false;
        }
        DetectLabelsRequest other = (DetectLabelsRequest)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getMaxLabels() == null ^ this.getMaxLabels() == null) {
            return false;
        }
        if (other.getMaxLabels() != null && !other.getMaxLabels().equals(this.getMaxLabels())) {
            return false;
        }
        if (other.getMinConfidence() == null ^ this.getMinConfidence() == null) {
            return false;
        }
        if (other.getMinConfidence() != null && !other.getMinConfidence().equals(this.getMinConfidence())) {
            return false;
        }
        if (other.getFeatures() == null ^ this.getFeatures() == null) {
            return false;
        }
        if (other.getFeatures() != null && !other.getFeatures().equals(this.getFeatures())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        return other.getSettings() == null || other.getSettings().equals(this.getSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getMaxLabels() == null ? 0 : this.getMaxLabels().hashCode());
        hashCode = 31 * hashCode + (this.getMinConfidence() == null ? 0 : this.getMinConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getFeatures() == null ? 0 : this.getFeatures().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        return hashCode;
    }

    public DetectLabelsRequest clone() {
        return (DetectLabelsRequest)super.clone();
    }
}

