/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.FaceRecord;
import com.amazonaws.services.rekognition.model.transform.FaceDetailJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.FaceJsonMarshaller;

public class FaceRecordJsonMarshaller {
    private static FaceRecordJsonMarshaller instance;

    public void marshall(FaceRecord faceRecord, StructuredJsonGenerator jsonGenerator) {
        if (faceRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (faceRecord.getFace() != null) {
                jsonGenerator.writeFieldName("Face");
                FaceJsonMarshaller.getInstance().marshall(faceRecord.getFace(), jsonGenerator);
            }
            if (faceRecord.getFaceDetail() != null) {
                jsonGenerator.writeFieldName("FaceDetail");
                FaceDetailJsonMarshaller.getInstance().marshall(faceRecord.getFaceDetail(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FaceRecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FaceRecordJsonMarshaller();
        }
        return instance;
    }
}

