/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Emotion;
import com.amazonaws.services.rekognition.model.FaceDetail;
import com.amazonaws.services.rekognition.model.Landmark;
import com.amazonaws.services.rekognition.model.transform.AgeRangeJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.BeardJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.BoundingBoxJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.EmotionJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.EyeOpenJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.EyeglassesJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.GenderJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.ImageQualityJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.LandmarkJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.MouthOpenJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.MustacheJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.PoseJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.SmileJsonMarshaller;
import com.amazonaws.services.rekognition.model.transform.SunglassesJsonMarshaller;
import java.util.List;

public class FaceDetailJsonMarshaller {
    private static FaceDetailJsonMarshaller instance;

    public void marshall(FaceDetail faceDetail, StructuredJsonGenerator jsonGenerator) {
        if (faceDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Landmark> landmarksList;
            List<Emotion> emotionsList;
            jsonGenerator.writeStartObject();
            if (faceDetail.getBoundingBox() != null) {
                jsonGenerator.writeFieldName("BoundingBox");
                BoundingBoxJsonMarshaller.getInstance().marshall(faceDetail.getBoundingBox(), jsonGenerator);
            }
            if (faceDetail.getAgeRange() != null) {
                jsonGenerator.writeFieldName("AgeRange");
                AgeRangeJsonMarshaller.getInstance().marshall(faceDetail.getAgeRange(), jsonGenerator);
            }
            if (faceDetail.getSmile() != null) {
                jsonGenerator.writeFieldName("Smile");
                SmileJsonMarshaller.getInstance().marshall(faceDetail.getSmile(), jsonGenerator);
            }
            if (faceDetail.getEyeglasses() != null) {
                jsonGenerator.writeFieldName("Eyeglasses");
                EyeglassesJsonMarshaller.getInstance().marshall(faceDetail.getEyeglasses(), jsonGenerator);
            }
            if (faceDetail.getSunglasses() != null) {
                jsonGenerator.writeFieldName("Sunglasses");
                SunglassesJsonMarshaller.getInstance().marshall(faceDetail.getSunglasses(), jsonGenerator);
            }
            if (faceDetail.getGender() != null) {
                jsonGenerator.writeFieldName("Gender");
                GenderJsonMarshaller.getInstance().marshall(faceDetail.getGender(), jsonGenerator);
            }
            if (faceDetail.getBeard() != null) {
                jsonGenerator.writeFieldName("Beard");
                BeardJsonMarshaller.getInstance().marshall(faceDetail.getBeard(), jsonGenerator);
            }
            if (faceDetail.getMustache() != null) {
                jsonGenerator.writeFieldName("Mustache");
                MustacheJsonMarshaller.getInstance().marshall(faceDetail.getMustache(), jsonGenerator);
            }
            if (faceDetail.getEyesOpen() != null) {
                jsonGenerator.writeFieldName("EyesOpen");
                EyeOpenJsonMarshaller.getInstance().marshall(faceDetail.getEyesOpen(), jsonGenerator);
            }
            if (faceDetail.getMouthOpen() != null) {
                jsonGenerator.writeFieldName("MouthOpen");
                MouthOpenJsonMarshaller.getInstance().marshall(faceDetail.getMouthOpen(), jsonGenerator);
            }
            if ((emotionsList = faceDetail.getEmotions()) != null) {
                jsonGenerator.writeFieldName("Emotions");
                jsonGenerator.writeStartArray();
                for (Emotion emotionsListValue : emotionsList) {
                    if (emotionsListValue == null) continue;
                    EmotionJsonMarshaller.getInstance().marshall(emotionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((landmarksList = faceDetail.getLandmarks()) != null) {
                jsonGenerator.writeFieldName("Landmarks");
                jsonGenerator.writeStartArray();
                for (Landmark landmarksListValue : landmarksList) {
                    if (landmarksListValue == null) continue;
                    LandmarkJsonMarshaller.getInstance().marshall(landmarksListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (faceDetail.getPose() != null) {
                jsonGenerator.writeFieldName("Pose");
                PoseJsonMarshaller.getInstance().marshall(faceDetail.getPose(), jsonGenerator);
            }
            if (faceDetail.getQuality() != null) {
                jsonGenerator.writeFieldName("Quality");
                ImageQualityJsonMarshaller.getInstance().marshall(faceDetail.getQuality(), jsonGenerator);
            }
            if (faceDetail.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(faceDetail.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FaceDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FaceDetailJsonMarshaller();
        }
        return instance;
    }
}

