/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Gender;

public class GenderJsonMarshaller {
    private static GenderJsonMarshaller instance;

    public void marshall(Gender gender, StructuredJsonGenerator jsonGenerator) {
        if (gender == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (gender.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(gender.getValue());
            }
            if (gender.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(gender.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GenderJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GenderJsonMarshaller();
        }
        return instance;
    }
}

