/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.Emotion;

public class EmotionJsonMarshaller {
    private static EmotionJsonMarshaller instance;

    public void marshall(Emotion emotion, StructuredJsonGenerator jsonGenerator) {
        if (emotion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (emotion.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(emotion.getType());
            }
            if (emotion.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(emotion.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EmotionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EmotionJsonMarshaller();
        }
        return instance;
    }
}

