/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.rekognition.AmazonRekognitionAsync;
import com.amazonaws.services.rekognition.AmazonRekognitionAsyncClientBuilder;
import com.amazonaws.services.rekognition.AmazonRekognitionClient;
import com.amazonaws.services.rekognition.model.CompareFacesRequest;
import com.amazonaws.services.rekognition.model.CompareFacesResult;
import com.amazonaws.services.rekognition.model.CreateCollectionRequest;
import com.amazonaws.services.rekognition.model.CreateCollectionResult;
import com.amazonaws.services.rekognition.model.CreateStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.CreateStreamProcessorResult;
import com.amazonaws.services.rekognition.model.DeleteCollectionRequest;
import com.amazonaws.services.rekognition.model.DeleteCollectionResult;
import com.amazonaws.services.rekognition.model.DeleteFacesRequest;
import com.amazonaws.services.rekognition.model.DeleteFacesResult;
import com.amazonaws.services.rekognition.model.DeleteStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.DeleteStreamProcessorResult;
import com.amazonaws.services.rekognition.model.DescribeCollectionRequest;
import com.amazonaws.services.rekognition.model.DescribeCollectionResult;
import com.amazonaws.services.rekognition.model.DescribeStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.DescribeStreamProcessorResult;
import com.amazonaws.services.rekognition.model.DetectFacesRequest;
import com.amazonaws.services.rekognition.model.DetectFacesResult;
import com.amazonaws.services.rekognition.model.DetectLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectLabelsResult;
import com.amazonaws.services.rekognition.model.DetectModerationLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectModerationLabelsResult;
import com.amazonaws.services.rekognition.model.DetectTextRequest;
import com.amazonaws.services.rekognition.model.DetectTextResult;
import com.amazonaws.services.rekognition.model.GetCelebrityInfoRequest;
import com.amazonaws.services.rekognition.model.GetCelebrityInfoResult;
import com.amazonaws.services.rekognition.model.GetCelebrityRecognitionRequest;
import com.amazonaws.services.rekognition.model.GetCelebrityRecognitionResult;
import com.amazonaws.services.rekognition.model.GetContentModerationRequest;
import com.amazonaws.services.rekognition.model.GetContentModerationResult;
import com.amazonaws.services.rekognition.model.GetFaceDetectionRequest;
import com.amazonaws.services.rekognition.model.GetFaceDetectionResult;
import com.amazonaws.services.rekognition.model.GetFaceSearchRequest;
import com.amazonaws.services.rekognition.model.GetFaceSearchResult;
import com.amazonaws.services.rekognition.model.GetLabelDetectionRequest;
import com.amazonaws.services.rekognition.model.GetLabelDetectionResult;
import com.amazonaws.services.rekognition.model.GetPersonTrackingRequest;
import com.amazonaws.services.rekognition.model.GetPersonTrackingResult;
import com.amazonaws.services.rekognition.model.IndexFacesRequest;
import com.amazonaws.services.rekognition.model.IndexFacesResult;
import com.amazonaws.services.rekognition.model.ListCollectionsRequest;
import com.amazonaws.services.rekognition.model.ListCollectionsResult;
import com.amazonaws.services.rekognition.model.ListFacesRequest;
import com.amazonaws.services.rekognition.model.ListFacesResult;
import com.amazonaws.services.rekognition.model.ListStreamProcessorsRequest;
import com.amazonaws.services.rekognition.model.ListStreamProcessorsResult;
import com.amazonaws.services.rekognition.model.RecognizeCelebritiesRequest;
import com.amazonaws.services.rekognition.model.RecognizeCelebritiesResult;
import com.amazonaws.services.rekognition.model.SearchFacesByImageRequest;
import com.amazonaws.services.rekognition.model.SearchFacesByImageResult;
import com.amazonaws.services.rekognition.model.SearchFacesRequest;
import com.amazonaws.services.rekognition.model.SearchFacesResult;
import com.amazonaws.services.rekognition.model.StartCelebrityRecognitionRequest;
import com.amazonaws.services.rekognition.model.StartCelebrityRecognitionResult;
import com.amazonaws.services.rekognition.model.StartContentModerationRequest;
import com.amazonaws.services.rekognition.model.StartContentModerationResult;
import com.amazonaws.services.rekognition.model.StartFaceDetectionRequest;
import com.amazonaws.services.rekognition.model.StartFaceDetectionResult;
import com.amazonaws.services.rekognition.model.StartFaceSearchRequest;
import com.amazonaws.services.rekognition.model.StartFaceSearchResult;
import com.amazonaws.services.rekognition.model.StartLabelDetectionRequest;
import com.amazonaws.services.rekognition.model.StartLabelDetectionResult;
import com.amazonaws.services.rekognition.model.StartPersonTrackingRequest;
import com.amazonaws.services.rekognition.model.StartPersonTrackingResult;
import com.amazonaws.services.rekognition.model.StartStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.StartStreamProcessorResult;
import com.amazonaws.services.rekognition.model.StopStreamProcessorRequest;
import com.amazonaws.services.rekognition.model.StopStreamProcessorResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRekognitionAsyncClient
extends AmazonRekognitionClient
implements AmazonRekognitionAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonRekognitionAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonRekognitionAsyncClientBuilder asyncBuilder() {
        return AmazonRekognitionAsyncClientBuilder.standard();
    }

    AmazonRekognitionAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CompareFacesResult> compareFacesAsync(CompareFacesRequest request) {
        return this.compareFacesAsync(request, null);
    }

    @Override
    public Future<CompareFacesResult> compareFacesAsync(CompareFacesRequest request, final AsyncHandler<CompareFacesRequest, CompareFacesResult> asyncHandler) {
        final CompareFacesRequest finalRequest = (CompareFacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CompareFacesResult>(){

            @Override
            public CompareFacesResult call() throws Exception {
                CompareFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeCompareFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request) {
        return this.createCollectionAsync(request, null);
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request, final AsyncHandler<CreateCollectionRequest, CreateCollectionResult> asyncHandler) {
        final CreateCollectionRequest finalRequest = (CreateCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCollectionResult>(){

            @Override
            public CreateCollectionResult call() throws Exception {
                CreateCollectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeCreateCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamProcessorResult> createStreamProcessorAsync(CreateStreamProcessorRequest request) {
        return this.createStreamProcessorAsync(request, null);
    }

    @Override
    public Future<CreateStreamProcessorResult> createStreamProcessorAsync(CreateStreamProcessorRequest request, final AsyncHandler<CreateStreamProcessorRequest, CreateStreamProcessorResult> asyncHandler) {
        final CreateStreamProcessorRequest finalRequest = (CreateStreamProcessorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStreamProcessorResult>(){

            @Override
            public CreateStreamProcessorResult call() throws Exception {
                CreateStreamProcessorResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeCreateStreamProcessor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request) {
        return this.deleteCollectionAsync(request, null);
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request, final AsyncHandler<DeleteCollectionRequest, DeleteCollectionResult> asyncHandler) {
        final DeleteCollectionRequest finalRequest = (DeleteCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCollectionResult>(){

            @Override
            public DeleteCollectionResult call() throws Exception {
                DeleteCollectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDeleteCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFacesResult> deleteFacesAsync(DeleteFacesRequest request) {
        return this.deleteFacesAsync(request, null);
    }

    @Override
    public Future<DeleteFacesResult> deleteFacesAsync(DeleteFacesRequest request, final AsyncHandler<DeleteFacesRequest, DeleteFacesResult> asyncHandler) {
        final DeleteFacesRequest finalRequest = (DeleteFacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFacesResult>(){

            @Override
            public DeleteFacesResult call() throws Exception {
                DeleteFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDeleteFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamProcessorResult> deleteStreamProcessorAsync(DeleteStreamProcessorRequest request) {
        return this.deleteStreamProcessorAsync(request, null);
    }

    @Override
    public Future<DeleteStreamProcessorResult> deleteStreamProcessorAsync(DeleteStreamProcessorRequest request, final AsyncHandler<DeleteStreamProcessorRequest, DeleteStreamProcessorResult> asyncHandler) {
        final DeleteStreamProcessorRequest finalRequest = (DeleteStreamProcessorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStreamProcessorResult>(){

            @Override
            public DeleteStreamProcessorResult call() throws Exception {
                DeleteStreamProcessorResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDeleteStreamProcessor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCollectionResult> describeCollectionAsync(DescribeCollectionRequest request) {
        return this.describeCollectionAsync(request, null);
    }

    @Override
    public Future<DescribeCollectionResult> describeCollectionAsync(DescribeCollectionRequest request, final AsyncHandler<DescribeCollectionRequest, DescribeCollectionResult> asyncHandler) {
        final DescribeCollectionRequest finalRequest = (DescribeCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCollectionResult>(){

            @Override
            public DescribeCollectionResult call() throws Exception {
                DescribeCollectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDescribeCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStreamProcessorResult> describeStreamProcessorAsync(DescribeStreamProcessorRequest request) {
        return this.describeStreamProcessorAsync(request, null);
    }

    @Override
    public Future<DescribeStreamProcessorResult> describeStreamProcessorAsync(DescribeStreamProcessorRequest request, final AsyncHandler<DescribeStreamProcessorRequest, DescribeStreamProcessorResult> asyncHandler) {
        final DescribeStreamProcessorRequest finalRequest = (DescribeStreamProcessorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStreamProcessorResult>(){

            @Override
            public DescribeStreamProcessorResult call() throws Exception {
                DescribeStreamProcessorResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDescribeStreamProcessor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectFacesResult> detectFacesAsync(DetectFacesRequest request) {
        return this.detectFacesAsync(request, null);
    }

    @Override
    public Future<DetectFacesResult> detectFacesAsync(DetectFacesRequest request, final AsyncHandler<DetectFacesRequest, DetectFacesResult> asyncHandler) {
        final DetectFacesRequest finalRequest = (DetectFacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectFacesResult>(){

            @Override
            public DetectFacesResult call() throws Exception {
                DetectFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectLabelsResult> detectLabelsAsync(DetectLabelsRequest request) {
        return this.detectLabelsAsync(request, null);
    }

    @Override
    public Future<DetectLabelsResult> detectLabelsAsync(DetectLabelsRequest request, final AsyncHandler<DetectLabelsRequest, DetectLabelsResult> asyncHandler) {
        final DetectLabelsRequest finalRequest = (DetectLabelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectLabelsResult>(){

            @Override
            public DetectLabelsResult call() throws Exception {
                DetectLabelsResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectLabels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectModerationLabelsResult> detectModerationLabelsAsync(DetectModerationLabelsRequest request) {
        return this.detectModerationLabelsAsync(request, null);
    }

    @Override
    public Future<DetectModerationLabelsResult> detectModerationLabelsAsync(DetectModerationLabelsRequest request, final AsyncHandler<DetectModerationLabelsRequest, DetectModerationLabelsResult> asyncHandler) {
        final DetectModerationLabelsRequest finalRequest = (DetectModerationLabelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectModerationLabelsResult>(){

            @Override
            public DetectModerationLabelsResult call() throws Exception {
                DetectModerationLabelsResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectModerationLabels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectTextResult> detectTextAsync(DetectTextRequest request) {
        return this.detectTextAsync(request, null);
    }

    @Override
    public Future<DetectTextResult> detectTextAsync(DetectTextRequest request, final AsyncHandler<DetectTextRequest, DetectTextResult> asyncHandler) {
        final DetectTextRequest finalRequest = (DetectTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectTextResult>(){

            @Override
            public DetectTextResult call() throws Exception {
                DetectTextResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCelebrityInfoResult> getCelebrityInfoAsync(GetCelebrityInfoRequest request) {
        return this.getCelebrityInfoAsync(request, null);
    }

    @Override
    public Future<GetCelebrityInfoResult> getCelebrityInfoAsync(GetCelebrityInfoRequest request, final AsyncHandler<GetCelebrityInfoRequest, GetCelebrityInfoResult> asyncHandler) {
        final GetCelebrityInfoRequest finalRequest = (GetCelebrityInfoRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCelebrityInfoResult>(){

            @Override
            public GetCelebrityInfoResult call() throws Exception {
                GetCelebrityInfoResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetCelebrityInfo(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCelebrityRecognitionResult> getCelebrityRecognitionAsync(GetCelebrityRecognitionRequest request) {
        return this.getCelebrityRecognitionAsync(request, null);
    }

    @Override
    public Future<GetCelebrityRecognitionResult> getCelebrityRecognitionAsync(GetCelebrityRecognitionRequest request, final AsyncHandler<GetCelebrityRecognitionRequest, GetCelebrityRecognitionResult> asyncHandler) {
        final GetCelebrityRecognitionRequest finalRequest = (GetCelebrityRecognitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCelebrityRecognitionResult>(){

            @Override
            public GetCelebrityRecognitionResult call() throws Exception {
                GetCelebrityRecognitionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetCelebrityRecognition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetContentModerationResult> getContentModerationAsync(GetContentModerationRequest request) {
        return this.getContentModerationAsync(request, null);
    }

    @Override
    public Future<GetContentModerationResult> getContentModerationAsync(GetContentModerationRequest request, final AsyncHandler<GetContentModerationRequest, GetContentModerationResult> asyncHandler) {
        final GetContentModerationRequest finalRequest = (GetContentModerationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetContentModerationResult>(){

            @Override
            public GetContentModerationResult call() throws Exception {
                GetContentModerationResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetContentModeration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFaceDetectionResult> getFaceDetectionAsync(GetFaceDetectionRequest request) {
        return this.getFaceDetectionAsync(request, null);
    }

    @Override
    public Future<GetFaceDetectionResult> getFaceDetectionAsync(GetFaceDetectionRequest request, final AsyncHandler<GetFaceDetectionRequest, GetFaceDetectionResult> asyncHandler) {
        final GetFaceDetectionRequest finalRequest = (GetFaceDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFaceDetectionResult>(){

            @Override
            public GetFaceDetectionResult call() throws Exception {
                GetFaceDetectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetFaceDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFaceSearchResult> getFaceSearchAsync(GetFaceSearchRequest request) {
        return this.getFaceSearchAsync(request, null);
    }

    @Override
    public Future<GetFaceSearchResult> getFaceSearchAsync(GetFaceSearchRequest request, final AsyncHandler<GetFaceSearchRequest, GetFaceSearchResult> asyncHandler) {
        final GetFaceSearchRequest finalRequest = (GetFaceSearchRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFaceSearchResult>(){

            @Override
            public GetFaceSearchResult call() throws Exception {
                GetFaceSearchResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetFaceSearch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLabelDetectionResult> getLabelDetectionAsync(GetLabelDetectionRequest request) {
        return this.getLabelDetectionAsync(request, null);
    }

    @Override
    public Future<GetLabelDetectionResult> getLabelDetectionAsync(GetLabelDetectionRequest request, final AsyncHandler<GetLabelDetectionRequest, GetLabelDetectionResult> asyncHandler) {
        final GetLabelDetectionRequest finalRequest = (GetLabelDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLabelDetectionResult>(){

            @Override
            public GetLabelDetectionResult call() throws Exception {
                GetLabelDetectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetLabelDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPersonTrackingResult> getPersonTrackingAsync(GetPersonTrackingRequest request) {
        return this.getPersonTrackingAsync(request, null);
    }

    @Override
    public Future<GetPersonTrackingResult> getPersonTrackingAsync(GetPersonTrackingRequest request, final AsyncHandler<GetPersonTrackingRequest, GetPersonTrackingResult> asyncHandler) {
        final GetPersonTrackingRequest finalRequest = (GetPersonTrackingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPersonTrackingResult>(){

            @Override
            public GetPersonTrackingResult call() throws Exception {
                GetPersonTrackingResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetPersonTracking(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<IndexFacesResult> indexFacesAsync(IndexFacesRequest request) {
        return this.indexFacesAsync(request, null);
    }

    @Override
    public Future<IndexFacesResult> indexFacesAsync(IndexFacesRequest request, final AsyncHandler<IndexFacesRequest, IndexFacesResult> asyncHandler) {
        final IndexFacesRequest finalRequest = (IndexFacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<IndexFacesResult>(){

            @Override
            public IndexFacesResult call() throws Exception {
                IndexFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeIndexFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request) {
        return this.listCollectionsAsync(request, null);
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request, final AsyncHandler<ListCollectionsRequest, ListCollectionsResult> asyncHandler) {
        final ListCollectionsRequest finalRequest = (ListCollectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCollectionsResult>(){

            @Override
            public ListCollectionsResult call() throws Exception {
                ListCollectionsResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeListCollections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFacesResult> listFacesAsync(ListFacesRequest request) {
        return this.listFacesAsync(request, null);
    }

    @Override
    public Future<ListFacesResult> listFacesAsync(ListFacesRequest request, final AsyncHandler<ListFacesRequest, ListFacesResult> asyncHandler) {
        final ListFacesRequest finalRequest = (ListFacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFacesResult>(){

            @Override
            public ListFacesResult call() throws Exception {
                ListFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeListFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamProcessorsResult> listStreamProcessorsAsync(ListStreamProcessorsRequest request) {
        return this.listStreamProcessorsAsync(request, null);
    }

    @Override
    public Future<ListStreamProcessorsResult> listStreamProcessorsAsync(ListStreamProcessorsRequest request, final AsyncHandler<ListStreamProcessorsRequest, ListStreamProcessorsResult> asyncHandler) {
        final ListStreamProcessorsRequest finalRequest = (ListStreamProcessorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStreamProcessorsResult>(){

            @Override
            public ListStreamProcessorsResult call() throws Exception {
                ListStreamProcessorsResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeListStreamProcessors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RecognizeCelebritiesResult> recognizeCelebritiesAsync(RecognizeCelebritiesRequest request) {
        return this.recognizeCelebritiesAsync(request, null);
    }

    @Override
    public Future<RecognizeCelebritiesResult> recognizeCelebritiesAsync(RecognizeCelebritiesRequest request, final AsyncHandler<RecognizeCelebritiesRequest, RecognizeCelebritiesResult> asyncHandler) {
        final RecognizeCelebritiesRequest finalRequest = (RecognizeCelebritiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RecognizeCelebritiesResult>(){

            @Override
            public RecognizeCelebritiesResult call() throws Exception {
                RecognizeCelebritiesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeRecognizeCelebrities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFacesResult> searchFacesAsync(SearchFacesRequest request) {
        return this.searchFacesAsync(request, null);
    }

    @Override
    public Future<SearchFacesResult> searchFacesAsync(SearchFacesRequest request, final AsyncHandler<SearchFacesRequest, SearchFacesResult> asyncHandler) {
        final SearchFacesRequest finalRequest = (SearchFacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchFacesResult>(){

            @Override
            public SearchFacesResult call() throws Exception {
                SearchFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeSearchFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFacesByImageResult> searchFacesByImageAsync(SearchFacesByImageRequest request) {
        return this.searchFacesByImageAsync(request, null);
    }

    @Override
    public Future<SearchFacesByImageResult> searchFacesByImageAsync(SearchFacesByImageRequest request, final AsyncHandler<SearchFacesByImageRequest, SearchFacesByImageResult> asyncHandler) {
        final SearchFacesByImageRequest finalRequest = (SearchFacesByImageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchFacesByImageResult>(){

            @Override
            public SearchFacesByImageResult call() throws Exception {
                SearchFacesByImageResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeSearchFacesByImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartCelebrityRecognitionResult> startCelebrityRecognitionAsync(StartCelebrityRecognitionRequest request) {
        return this.startCelebrityRecognitionAsync(request, null);
    }

    @Override
    public Future<StartCelebrityRecognitionResult> startCelebrityRecognitionAsync(StartCelebrityRecognitionRequest request, final AsyncHandler<StartCelebrityRecognitionRequest, StartCelebrityRecognitionResult> asyncHandler) {
        final StartCelebrityRecognitionRequest finalRequest = (StartCelebrityRecognitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartCelebrityRecognitionResult>(){

            @Override
            public StartCelebrityRecognitionResult call() throws Exception {
                StartCelebrityRecognitionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStartCelebrityRecognition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartContentModerationResult> startContentModerationAsync(StartContentModerationRequest request) {
        return this.startContentModerationAsync(request, null);
    }

    @Override
    public Future<StartContentModerationResult> startContentModerationAsync(StartContentModerationRequest request, final AsyncHandler<StartContentModerationRequest, StartContentModerationResult> asyncHandler) {
        final StartContentModerationRequest finalRequest = (StartContentModerationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartContentModerationResult>(){

            @Override
            public StartContentModerationResult call() throws Exception {
                StartContentModerationResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStartContentModeration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFaceDetectionResult> startFaceDetectionAsync(StartFaceDetectionRequest request) {
        return this.startFaceDetectionAsync(request, null);
    }

    @Override
    public Future<StartFaceDetectionResult> startFaceDetectionAsync(StartFaceDetectionRequest request, final AsyncHandler<StartFaceDetectionRequest, StartFaceDetectionResult> asyncHandler) {
        final StartFaceDetectionRequest finalRequest = (StartFaceDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFaceDetectionResult>(){

            @Override
            public StartFaceDetectionResult call() throws Exception {
                StartFaceDetectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStartFaceDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFaceSearchResult> startFaceSearchAsync(StartFaceSearchRequest request) {
        return this.startFaceSearchAsync(request, null);
    }

    @Override
    public Future<StartFaceSearchResult> startFaceSearchAsync(StartFaceSearchRequest request, final AsyncHandler<StartFaceSearchRequest, StartFaceSearchResult> asyncHandler) {
        final StartFaceSearchRequest finalRequest = (StartFaceSearchRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFaceSearchResult>(){

            @Override
            public StartFaceSearchResult call() throws Exception {
                StartFaceSearchResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStartFaceSearch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartLabelDetectionResult> startLabelDetectionAsync(StartLabelDetectionRequest request) {
        return this.startLabelDetectionAsync(request, null);
    }

    @Override
    public Future<StartLabelDetectionResult> startLabelDetectionAsync(StartLabelDetectionRequest request, final AsyncHandler<StartLabelDetectionRequest, StartLabelDetectionResult> asyncHandler) {
        final StartLabelDetectionRequest finalRequest = (StartLabelDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartLabelDetectionResult>(){

            @Override
            public StartLabelDetectionResult call() throws Exception {
                StartLabelDetectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStartLabelDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPersonTrackingResult> startPersonTrackingAsync(StartPersonTrackingRequest request) {
        return this.startPersonTrackingAsync(request, null);
    }

    @Override
    public Future<StartPersonTrackingResult> startPersonTrackingAsync(StartPersonTrackingRequest request, final AsyncHandler<StartPersonTrackingRequest, StartPersonTrackingResult> asyncHandler) {
        final StartPersonTrackingRequest finalRequest = (StartPersonTrackingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartPersonTrackingResult>(){

            @Override
            public StartPersonTrackingResult call() throws Exception {
                StartPersonTrackingResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStartPersonTracking(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartStreamProcessorResult> startStreamProcessorAsync(StartStreamProcessorRequest request) {
        return this.startStreamProcessorAsync(request, null);
    }

    @Override
    public Future<StartStreamProcessorResult> startStreamProcessorAsync(StartStreamProcessorRequest request, final AsyncHandler<StartStreamProcessorRequest, StartStreamProcessorResult> asyncHandler) {
        final StartStreamProcessorRequest finalRequest = (StartStreamProcessorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartStreamProcessorResult>(){

            @Override
            public StartStreamProcessorResult call() throws Exception {
                StartStreamProcessorResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStartStreamProcessor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopStreamProcessorResult> stopStreamProcessorAsync(StopStreamProcessorRequest request) {
        return this.stopStreamProcessorAsync(request, null);
    }

    @Override
    public Future<StopStreamProcessorResult> stopStreamProcessorAsync(StopStreamProcessorRequest request, final AsyncHandler<StopStreamProcessorRequest, StopStreamProcessorResult> asyncHandler) {
        final StopStreamProcessorRequest finalRequest = (StopStreamProcessorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopStreamProcessorResult>(){

            @Override
            public StopStreamProcessorResult call() throws Exception {
                StopStreamProcessorResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeStopStreamProcessor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

