/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.ContentModerationDetection;
import com.amazonaws.services.rekognition.model.VideoJobStatus;
import com.amazonaws.services.rekognition.model.VideoMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetContentModerationResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String jobStatus;
    private String statusMessage;
    private VideoMetadata videoMetadata;
    private List<ContentModerationDetection> moderationLabels;
    private String nextToken;

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public GetContentModerationResult withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public GetContentModerationResult withJobStatus(VideoJobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetContentModerationResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setVideoMetadata(VideoMetadata videoMetadata) {
        this.videoMetadata = videoMetadata;
    }

    public VideoMetadata getVideoMetadata() {
        return this.videoMetadata;
    }

    public GetContentModerationResult withVideoMetadata(VideoMetadata videoMetadata) {
        this.setVideoMetadata(videoMetadata);
        return this;
    }

    public List<ContentModerationDetection> getModerationLabels() {
        return this.moderationLabels;
    }

    public void setModerationLabels(Collection<ContentModerationDetection> moderationLabels) {
        if (moderationLabels == null) {
            this.moderationLabels = null;
            return;
        }
        this.moderationLabels = new ArrayList<ContentModerationDetection>(moderationLabels);
    }

    public GetContentModerationResult withModerationLabels(ContentModerationDetection ... moderationLabels) {
        if (this.moderationLabels == null) {
            this.setModerationLabels(new ArrayList<ContentModerationDetection>(moderationLabels.length));
        }
        for (ContentModerationDetection ele : moderationLabels) {
            this.moderationLabels.add(ele);
        }
        return this;
    }

    public GetContentModerationResult withModerationLabels(Collection<ContentModerationDetection> moderationLabels) {
        this.setModerationLabels(moderationLabels);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetContentModerationResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getVideoMetadata() != null) {
            sb.append("VideoMetadata: ").append(this.getVideoMetadata()).append(",");
        }
        if (this.getModerationLabels() != null) {
            sb.append("ModerationLabels: ").append(this.getModerationLabels()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContentModerationResult)) {
            return false;
        }
        GetContentModerationResult other = (GetContentModerationResult)obj;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getVideoMetadata() == null ^ this.getVideoMetadata() == null) {
            return false;
        }
        if (other.getVideoMetadata() != null && !other.getVideoMetadata().equals(this.getVideoMetadata())) {
            return false;
        }
        if (other.getModerationLabels() == null ^ this.getModerationLabels() == null) {
            return false;
        }
        if (other.getModerationLabels() != null && !other.getModerationLabels().equals(this.getModerationLabels())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getVideoMetadata() == null ? 0 : this.getVideoMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getModerationLabels() == null ? 0 : this.getModerationLabels().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetContentModerationResult clone() {
        try {
            return (GetContentModerationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

