/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.Section;
import com.amazonaws.services.rekognition.model.transform.WarningMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Warning
implements Serializable,
Cloneable,
StructuredPojo {
    private String errorCode;
    private String message;
    private List<Section> sections;

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Warning withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Warning withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public void setSections(Collection<Section> sections) {
        if (sections == null) {
            this.sections = null;
            return;
        }
        this.sections = new ArrayList<Section>(sections);
    }

    public Warning withSections(Section ... sections) {
        if (this.sections == null) {
            this.setSections(new ArrayList<Section>(sections.length));
        }
        for (Section ele : sections) {
            this.sections.add(ele);
        }
        return this;
    }

    public Warning withSections(Collection<Section> sections) {
        this.setSections(sections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getSections() != null) {
            sb.append("Sections: ").append(this.getSections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Warning)) {
            return false;
        }
        Warning other = (Warning)obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getSections() == null ^ this.getSections() == null) {
            return false;
        }
        return other.getSections() == null || other.getSections().equals(this.getSections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getSections() == null ? 0 : this.getSections().hashCode());
        return hashCode;
    }

    public Warning clone() {
        try {
            return (Warning)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WarningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

