/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.Face;

@SdkInternalApi
public class FaceMarshaller {
    private static final MarshallingInfo<String> FACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceId").build();
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox").build();
    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageId").build();
    private static final MarshallingInfo<String> EXTERNALIMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalImageId").build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").build();
    private static final MarshallingInfo<Float> ASSOCIATIONSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationScore").build();
    private static final FaceMarshaller instance = new FaceMarshaller();

    public static FaceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Face face, ProtocolMarshaller protocolMarshaller) {
        if (face == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)face.getFaceId(), FACEID_BINDING);
            protocolMarshaller.marshall((Object)face.getBoundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall((Object)face.getImageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall((Object)face.getExternalImageId(), EXTERNALIMAGEID_BINDING);
            protocolMarshaller.marshall((Object)face.getConfidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)face.getAssociationScore(), ASSOCIATIONSCORE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

