/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rekognition.model.Attribute;
import com.amazonaws.services.rekognition.model.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IndexFacesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String collectionId;
    private Image image;
    private String externalImageId;
    private List<String> detectionAttributes;

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public IndexFacesRequest withCollectionId(String collectionId) {
        this.setCollectionId(collectionId);
        return this;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public IndexFacesRequest withImage(Image image) {
        this.setImage(image);
        return this;
    }

    public void setExternalImageId(String externalImageId) {
        this.externalImageId = externalImageId;
    }

    public String getExternalImageId() {
        return this.externalImageId;
    }

    public IndexFacesRequest withExternalImageId(String externalImageId) {
        this.setExternalImageId(externalImageId);
        return this;
    }

    public List<String> getDetectionAttributes() {
        return this.detectionAttributes;
    }

    public void setDetectionAttributes(Collection<String> detectionAttributes) {
        if (detectionAttributes == null) {
            this.detectionAttributes = null;
            return;
        }
        this.detectionAttributes = new ArrayList<String>(detectionAttributes);
    }

    public IndexFacesRequest withDetectionAttributes(String ... detectionAttributes) {
        if (this.detectionAttributes == null) {
            this.setDetectionAttributes(new ArrayList<String>(detectionAttributes.length));
        }
        for (String ele : detectionAttributes) {
            this.detectionAttributes.add(ele);
        }
        return this;
    }

    public IndexFacesRequest withDetectionAttributes(Collection<String> detectionAttributes) {
        this.setDetectionAttributes(detectionAttributes);
        return this;
    }

    public IndexFacesRequest withDetectionAttributes(Attribute ... detectionAttributes) {
        ArrayList<String> detectionAttributesCopy = new ArrayList<String>(detectionAttributes.length);
        for (Attribute value : detectionAttributes) {
            detectionAttributesCopy.add(value.toString());
        }
        if (this.getDetectionAttributes() == null) {
            this.setDetectionAttributes(detectionAttributesCopy);
        } else {
            this.getDetectionAttributes().addAll(detectionAttributesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCollectionId() != null) {
            sb.append("CollectionId: ").append(this.getCollectionId()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getExternalImageId() != null) {
            sb.append("ExternalImageId: ").append(this.getExternalImageId()).append(",");
        }
        if (this.getDetectionAttributes() != null) {
            sb.append("DetectionAttributes: ").append(this.getDetectionAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest)obj;
        if (other.getCollectionId() == null ^ this.getCollectionId() == null) {
            return false;
        }
        if (other.getCollectionId() != null && !other.getCollectionId().equals(this.getCollectionId())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getExternalImageId() == null ^ this.getExternalImageId() == null) {
            return false;
        }
        if (other.getExternalImageId() != null && !other.getExternalImageId().equals(this.getExternalImageId())) {
            return false;
        }
        if (other.getDetectionAttributes() == null ^ this.getDetectionAttributes() == null) {
            return false;
        }
        return other.getDetectionAttributes() == null || other.getDetectionAttributes().equals(this.getDetectionAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCollectionId() == null ? 0 : this.getCollectionId().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getExternalImageId() == null ? 0 : this.getExternalImageId().hashCode());
        hashCode = 31 * hashCode + (this.getDetectionAttributes() == null ? 0 : this.getDetectionAttributes().hashCode());
        return hashCode;
    }

    public IndexFacesRequest clone() {
        return (IndexFacesRequest)super.clone();
    }
}

