/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftserverless.model;

import javax.annotation.Generated;

/**
 * <p>
 * There are no subnets in your VPC with associated IPv6 CIDR blocks. To use dual-stack mode, associate an IPv6 CIDR
 * block with each subnet in your VPC.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Ipv6CidrBlockNotFoundException extends com.amazonaws.services.redshiftserverless.model.AWSRedshiftServerlessException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new Ipv6CidrBlockNotFoundException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public Ipv6CidrBlockNotFoundException(String message) {
        super(message);
    }

}
