/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.Subnet;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ClusterSubnetGroup
implements Serializable,
Cloneable {
    private String clusterSubnetGroupName;
    private String description;
    private String vpcId;
    private String subnetGroupStatus;
    private SdkInternalList<Subnet> subnets;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<String> supportedClusterIpAddressTypes;

    public void setClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
    }

    public String getClusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public ClusterSubnetGroup withClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.setClusterSubnetGroupName(clusterSubnetGroupName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ClusterSubnetGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public ClusterSubnetGroup withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setSubnetGroupStatus(String subnetGroupStatus) {
        this.subnetGroupStatus = subnetGroupStatus;
    }

    public String getSubnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public ClusterSubnetGroup withSubnetGroupStatus(String subnetGroupStatus) {
        this.setSubnetGroupStatus(subnetGroupStatus);
        return this;
    }

    public List<Subnet> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new SdkInternalList();
        }
        return this.subnets;
    }

    public void setSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new SdkInternalList(subnets);
    }

    public ClusterSubnetGroup withSubnets(Subnet ... subnets) {
        if (this.subnets == null) {
            this.setSubnets((Collection<Subnet>)new SdkInternalList(subnets.length));
        }
        for (Subnet ele : subnets) {
            this.subnets.add((Object)ele);
        }
        return this;
    }

    public ClusterSubnetGroup withSubnets(Collection<Subnet> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public ClusterSubnetGroup withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public ClusterSubnetGroup withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getSupportedClusterIpAddressTypes() {
        if (this.supportedClusterIpAddressTypes == null) {
            this.supportedClusterIpAddressTypes = new SdkInternalList();
        }
        return this.supportedClusterIpAddressTypes;
    }

    public void setSupportedClusterIpAddressTypes(Collection<String> supportedClusterIpAddressTypes) {
        if (supportedClusterIpAddressTypes == null) {
            this.supportedClusterIpAddressTypes = null;
            return;
        }
        this.supportedClusterIpAddressTypes = new SdkInternalList(supportedClusterIpAddressTypes);
    }

    public ClusterSubnetGroup withSupportedClusterIpAddressTypes(String ... supportedClusterIpAddressTypes) {
        if (this.supportedClusterIpAddressTypes == null) {
            this.setSupportedClusterIpAddressTypes((Collection<String>)new SdkInternalList(supportedClusterIpAddressTypes.length));
        }
        for (String ele : supportedClusterIpAddressTypes) {
            this.supportedClusterIpAddressTypes.add((Object)ele);
        }
        return this;
    }

    public ClusterSubnetGroup withSupportedClusterIpAddressTypes(Collection<String> supportedClusterIpAddressTypes) {
        this.setSupportedClusterIpAddressTypes(supportedClusterIpAddressTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.getClusterSubnetGroupName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnetGroupStatus() != null) {
            sb.append("SubnetGroupStatus: ").append(this.getSubnetGroupStatus()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSupportedClusterIpAddressTypes() != null) {
            sb.append("SupportedClusterIpAddressTypes: ").append(this.getSupportedClusterIpAddressTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSubnetGroup)) {
            return false;
        }
        ClusterSubnetGroup other = (ClusterSubnetGroup)obj;
        if (other.getClusterSubnetGroupName() == null ^ this.getClusterSubnetGroupName() == null) {
            return false;
        }
        if (other.getClusterSubnetGroupName() != null && !other.getClusterSubnetGroupName().equals(this.getClusterSubnetGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetGroupStatus() == null ^ this.getSubnetGroupStatus() == null) {
            return false;
        }
        if (other.getSubnetGroupStatus() != null && !other.getSubnetGroupStatus().equals(this.getSubnetGroupStatus())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSupportedClusterIpAddressTypes() == null ^ this.getSupportedClusterIpAddressTypes() == null) {
            return false;
        }
        return other.getSupportedClusterIpAddressTypes() == null || other.getSupportedClusterIpAddressTypes().equals(this.getSupportedClusterIpAddressTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterSubnetGroupName() == null ? 0 : this.getClusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetGroupStatus() == null ? 0 : this.getSubnetGroupStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedClusterIpAddressTypes() == null ? 0 : this.getSupportedClusterIpAddressTypes().hashCode());
        return hashCode;
    }

    public ClusterSubnetGroup clone() {
        try {
            return (ClusterSubnetGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

