/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshift.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeCustomDomainAssociations"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeCustomDomainAssociationsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The marker for the custom domain association.
     * </p>
     */
    private String marker;
    /**
     * <p>
     * The associations for the custom domain.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Association> associations;

    /**
     * <p>
     * The marker for the custom domain association.
     * </p>
     * 
     * @param marker
     *        The marker for the custom domain association.
     */

    public void setMarker(String marker) {
        this.marker = marker;
    }

    /**
     * <p>
     * The marker for the custom domain association.
     * </p>
     * 
     * @return The marker for the custom domain association.
     */

    public String getMarker() {
        return this.marker;
    }

    /**
     * <p>
     * The marker for the custom domain association.
     * </p>
     * 
     * @param marker
     *        The marker for the custom domain association.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeCustomDomainAssociationsResult withMarker(String marker) {
        setMarker(marker);
        return this;
    }

    /**
     * <p>
     * The associations for the custom domain.
     * </p>
     * 
     * @return The associations for the custom domain.
     */

    public java.util.List<Association> getAssociations() {
        if (associations == null) {
            associations = new com.amazonaws.internal.SdkInternalList<Association>();
        }
        return associations;
    }

    /**
     * <p>
     * The associations for the custom domain.
     * </p>
     * 
     * @param associations
     *        The associations for the custom domain.
     */

    public void setAssociations(java.util.Collection<Association> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }

        this.associations = new com.amazonaws.internal.SdkInternalList<Association>(associations);
    }

    /**
     * <p>
     * The associations for the custom domain.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAssociations(java.util.Collection)} or {@link #withAssociations(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param associations
     *        The associations for the custom domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeCustomDomainAssociationsResult withAssociations(Association... associations) {
        if (this.associations == null) {
            setAssociations(new com.amazonaws.internal.SdkInternalList<Association>(associations.length));
        }
        for (Association ele : associations) {
            this.associations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The associations for the custom domain.
     * </p>
     * 
     * @param associations
     *        The associations for the custom domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeCustomDomainAssociationsResult withAssociations(java.util.Collection<Association> associations) {
        setAssociations(associations);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMarker() != null)
            sb.append("Marker: ").append(getMarker()).append(",");
        if (getAssociations() != null)
            sb.append("Associations: ").append(getAssociations());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeCustomDomainAssociationsResult == false)
            return false;
        DescribeCustomDomainAssociationsResult other = (DescribeCustomDomainAssociationsResult) obj;
        if (other.getMarker() == null ^ this.getMarker() == null)
            return false;
        if (other.getMarker() != null && other.getMarker().equals(this.getMarker()) == false)
            return false;
        if (other.getAssociations() == null ^ this.getAssociations() == null)
            return false;
        if (other.getAssociations() != null && other.getAssociations().equals(this.getAssociations()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMarker() == null) ? 0 : getMarker().hashCode());
        hashCode = prime * hashCode + ((getAssociations() == null) ? 0 : getAssociations().hashCode());
        return hashCode;
    }

    @Override
    public DescribeCustomDomainAssociationsResult clone() {
        try {
            return (DescribeCustomDomainAssociationsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
