/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.ReferenceLink;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ReferenceLinkStaxUnmarshaller
implements Unmarshaller<ReferenceLink, StaxUnmarshallerContext> {
    private static ReferenceLinkStaxUnmarshaller instance;

    public ReferenceLink unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReferenceLink referenceLink = new ReferenceLink();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return referenceLink;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Text", targetDepth)) {
                    referenceLink.setText(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Link", targetDepth)) continue;
                referenceLink.setLink(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return referenceLink;
    }

    public static ReferenceLinkStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReferenceLinkStaxUnmarshaller();
        }
        return instance;
    }
}

