/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.AuthorizeDataShareRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AuthorizeDataShareRequestMarshaller
implements Marshaller<Request<AuthorizeDataShareRequest>, AuthorizeDataShareRequest> {
    public Request<AuthorizeDataShareRequest> marshall(AuthorizeDataShareRequest authorizeDataShareRequest) {
        if (authorizeDataShareRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeDataShareRequest, "AmazonRedshift");
        request.addParameter("Action", "AuthorizeDataShare");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeDataShareRequest.getDataShareArn() != null) {
            request.addParameter("DataShareArn", StringUtils.fromString((String)authorizeDataShareRequest.getDataShareArn()));
        }
        if (authorizeDataShareRequest.getConsumerIdentifier() != null) {
            request.addParameter("ConsumerIdentifier", StringUtils.fromString((String)authorizeDataShareRequest.getConsumerIdentifier()));
        }
        return request;
    }
}

