/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.LogDestinationType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EnableLoggingRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterIdentifier;
    private String bucketName;
    private String s3KeyPrefix;
    private String logDestinationType;
    private SdkInternalList<String> logExports;

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public EnableLoggingRequest withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public EnableLoggingRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setS3KeyPrefix(String s3KeyPrefix) {
        this.s3KeyPrefix = s3KeyPrefix;
    }

    public String getS3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public EnableLoggingRequest withS3KeyPrefix(String s3KeyPrefix) {
        this.setS3KeyPrefix(s3KeyPrefix);
        return this;
    }

    public void setLogDestinationType(String logDestinationType) {
        this.logDestinationType = logDestinationType;
    }

    public String getLogDestinationType() {
        return this.logDestinationType;
    }

    public EnableLoggingRequest withLogDestinationType(String logDestinationType) {
        this.setLogDestinationType(logDestinationType);
        return this;
    }

    public EnableLoggingRequest withLogDestinationType(LogDestinationType logDestinationType) {
        this.logDestinationType = logDestinationType.toString();
        return this;
    }

    public List<String> getLogExports() {
        if (this.logExports == null) {
            this.logExports = new SdkInternalList();
        }
        return this.logExports;
    }

    public void setLogExports(Collection<String> logExports) {
        if (logExports == null) {
            this.logExports = null;
            return;
        }
        this.logExports = new SdkInternalList(logExports);
    }

    public EnableLoggingRequest withLogExports(String ... logExports) {
        if (this.logExports == null) {
            this.setLogExports((Collection<String>)new SdkInternalList(logExports.length));
        }
        for (String ele : logExports) {
            this.logExports.add((Object)ele);
        }
        return this;
    }

    public EnableLoggingRequest withLogExports(Collection<String> logExports) {
        this.setLogExports(logExports);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.getClusterIdentifier()).append(",");
        }
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getS3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.getS3KeyPrefix()).append(",");
        }
        if (this.getLogDestinationType() != null) {
            sb.append("LogDestinationType: ").append(this.getLogDestinationType()).append(",");
        }
        if (this.getLogExports() != null) {
            sb.append("LogExports: ").append(this.getLogExports());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableLoggingRequest)) {
            return false;
        }
        EnableLoggingRequest other = (EnableLoggingRequest)obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getS3KeyPrefix() == null ^ this.getS3KeyPrefix() == null) {
            return false;
        }
        if (other.getS3KeyPrefix() != null && !other.getS3KeyPrefix().equals(this.getS3KeyPrefix())) {
            return false;
        }
        if (other.getLogDestinationType() == null ^ this.getLogDestinationType() == null) {
            return false;
        }
        if (other.getLogDestinationType() != null && !other.getLogDestinationType().equals(this.getLogDestinationType())) {
            return false;
        }
        if (other.getLogExports() == null ^ this.getLogExports() == null) {
            return false;
        }
        return other.getLogExports() == null || other.getLogExports().equals(this.getLogExports());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getS3KeyPrefix() == null ? 0 : this.getS3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getLogDestinationType() == null ? 0 : this.getLogDestinationType().hashCode());
        hashCode = 31 * hashCode + (this.getLogExports() == null ? 0 : this.getLogExports().hashCode());
        return hashCode;
    }

    public EnableLoggingRequest clone() {
        return (EnableLoggingRequest)super.clone();
    }
}

