/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateHsmClientCertificateRequestMarshaller
implements Marshaller<Request<CreateHsmClientCertificateRequest>, CreateHsmClientCertificateRequest> {
    public Request<CreateHsmClientCertificateRequest> marshall(CreateHsmClientCertificateRequest createHsmClientCertificateRequest) {
        if (createHsmClientCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHsmClientCertificateRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateHsmClientCertificate");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createHsmClientCertificateRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)createHsmClientCertificateRequest.getHsmClientCertificateIdentifier()));
        }
        if (!createHsmClientCertificateRequest.getTags().isEmpty() || !((SdkInternalList)createHsmClientCertificateRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createHsmClientCertificateRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

