/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.CreateClusterRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateClusterRequestMarshaller
implements Marshaller<Request<CreateClusterRequest>, CreateClusterRequest> {
    public Request<CreateClusterRequest> marshall(CreateClusterRequest createClusterRequest) {
        SdkInternalList iamRolesList;
        SdkInternalList tagsList;
        SdkInternalList vpcSecurityGroupIdsList;
        SdkInternalList clusterSecurityGroupsList;
        if (createClusterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createClusterRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterRequest.getDBName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)createClusterRequest.getDBName()));
        }
        if (createClusterRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)createClusterRequest.getClusterIdentifier()));
        }
        if (createClusterRequest.getClusterType() != null) {
            request.addParameter("ClusterType", StringUtils.fromString((String)createClusterRequest.getClusterType()));
        }
        if (createClusterRequest.getNodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)createClusterRequest.getNodeType()));
        }
        if (createClusterRequest.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createClusterRequest.getMasterUsername()));
        }
        if (createClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createClusterRequest.getMasterUserPassword()));
        }
        if (!(clusterSecurityGroupsList = (SdkInternalList)createClusterRequest.getClusterSecurityGroups()).isEmpty() || !clusterSecurityGroupsList.isAutoConstruct()) {
            int clusterSecurityGroupsListIndex = 1;
            for (Object clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
                if (clusterSecurityGroupsListValue != null) {
                    request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)clusterSecurityGroupsListValue));
                }
                ++clusterSecurityGroupsListIndex;
            }
        }
        if (!(vpcSecurityGroupIdsList = (SdkInternalList)createClusterRequest.getVpcSecurityGroupIds()).isEmpty() || !vpcSecurityGroupIdsList.isAutoConstruct()) {
            int vpcSecurityGroupIdsListIndex = 1;
            for (Object vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createClusterRequest.getClusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)createClusterRequest.getClusterSubnetGroupName()));
        }
        if (createClusterRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createClusterRequest.getAvailabilityZone()));
        }
        if (createClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (createClusterRequest.getClusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)createClusterRequest.getClusterParameterGroupName()));
        }
        if (createClusterRequest.getAutomatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)createClusterRequest.getAutomatedSnapshotRetentionPeriod()));
        }
        if (createClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createClusterRequest.getPort()));
        }
        if (createClusterRequest.getClusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)createClusterRequest.getClusterVersion()));
        }
        if (createClusterRequest.getAllowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)createClusterRequest.getAllowVersionUpgrade()));
        }
        if (createClusterRequest.getNumberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringUtils.fromInteger((Integer)createClusterRequest.getNumberOfNodes()));
        }
        if (createClusterRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)createClusterRequest.getPubliclyAccessible()));
        }
        if (createClusterRequest.getEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)createClusterRequest.getEncrypted()));
        }
        if (createClusterRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)createClusterRequest.getHsmClientCertificateIdentifier()));
        }
        if (createClusterRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)createClusterRequest.getHsmConfigurationIdentifier()));
        }
        if (createClusterRequest.getElasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString((String)createClusterRequest.getElasticIp()));
        }
        if (!(tagsList = (SdkInternalList)createClusterRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createClusterRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createClusterRequest.getKmsKeyId()));
        }
        if (createClusterRequest.getEnhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringUtils.fromBoolean((Boolean)createClusterRequest.getEnhancedVpcRouting()));
        }
        if (createClusterRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)createClusterRequest.getAdditionalInfo()));
        }
        if (!(iamRolesList = (SdkInternalList)createClusterRequest.getIamRoles()).isEmpty() || !iamRolesList.isAutoConstruct()) {
            int iamRolesListIndex = 1;
            for (String iamRolesListValue : iamRolesList) {
                if (iamRolesListValue != null) {
                    request.addParameter("IamRoles.IamRoleArn." + iamRolesListIndex, StringUtils.fromString((String)iamRolesListValue));
                }
                ++iamRolesListIndex;
            }
        }
        return request;
    }
}

