/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.RecurringCharge;
import com.amazonaws.services.redshift.model.ReservedNode;
import com.amazonaws.services.redshift.model.transform.RecurringChargeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ReservedNodeStaxUnmarshaller
implements Unmarshaller<ReservedNode, StaxUnmarshallerContext> {
    private static ReservedNodeStaxUnmarshaller instance;

    public ReservedNode unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedNode reservedNode = new ReservedNode();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return reservedNode;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ReservedNodeId", targetDepth)) {
                    reservedNode.setReservedNodeId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReservedNodeOfferingId", targetDepth)) {
                    reservedNode.setReservedNodeOfferingId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeType", targetDepth)) {
                    reservedNode.setNodeType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    reservedNode.setStartTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Duration", targetDepth)) {
                    reservedNode.setDuration(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FixedPrice", targetDepth)) {
                    reservedNode.setFixedPrice(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UsagePrice", targetDepth)) {
                    reservedNode.setUsagePrice(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CurrencyCode", targetDepth)) {
                    reservedNode.setCurrencyCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeCount", targetDepth)) {
                    reservedNode.setNodeCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("State", targetDepth)) {
                    reservedNode.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OfferingType", targetDepth)) {
                    reservedNode.setOfferingType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RecurringCharges", targetDepth)) {
                    reservedNode.withRecurringCharges(new ArrayList<RecurringCharge>());
                    continue;
                }
                if (context.testExpression("RecurringCharges/RecurringCharge", targetDepth)) {
                    reservedNode.withRecurringCharges(RecurringChargeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ReservedNodeOfferingType", targetDepth)) continue;
                reservedNode.setReservedNodeOfferingType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return reservedNode;
    }

    public static ReservedNodeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReservedNodeStaxUnmarshaller();
        }
        return instance;
    }
}

