/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RestoreFromClusterSnapshotRequestMarshaller
implements Marshaller<Request<RestoreFromClusterSnapshotRequest>, RestoreFromClusterSnapshotRequest> {
    public Request<RestoreFromClusterSnapshotRequest> marshall(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) {
        if (restoreFromClusterSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreFromClusterSnapshotRequest, "AmazonRedshift");
        request.addParameter("Action", "RestoreFromClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        if (restoreFromClusterSnapshotRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getClusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getSnapshotIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getSnapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getSnapshotClusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreFromClusterSnapshotRequest.getPort()));
        }
        if (restoreFromClusterSnapshotRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getAvailabilityZone()));
        }
        if (restoreFromClusterSnapshotRequest.isAllowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.isAllowVersionUpgrade()));
        }
        if (restoreFromClusterSnapshotRequest.getClusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getClusterSubnetGroupName()));
        }
        if (restoreFromClusterSnapshotRequest.isPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.isPubliclyAccessible()));
        }
        if (restoreFromClusterSnapshotRequest.getOwnerAccount() != null) {
            request.addParameter("OwnerAccount", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getOwnerAccount()));
        }
        if (restoreFromClusterSnapshotRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getHsmClientCertificateIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getHsmConfigurationIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getElasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getElasticIp()));
        }
        if (restoreFromClusterSnapshotRequest.getClusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getClusterParameterGroupName()));
        }
        List<String> clusterSecurityGroupsList = restoreFromClusterSnapshotRequest.getClusterSecurityGroups();
        int clusterSecurityGroupsListIndex = 1;
        for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
            if (clusterSecurityGroupsListValue != null) {
                request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)clusterSecurityGroupsListValue));
            }
            ++clusterSecurityGroupsListIndex;
        }
        List<String> vpcSecurityGroupIdsList = restoreFromClusterSnapshotRequest.getVpcSecurityGroupIds();
        int vpcSecurityGroupIdsListIndex = 1;
        for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
            if (vpcSecurityGroupIdsListValue != null) {
                request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
            }
            ++vpcSecurityGroupIdsListIndex;
        }
        if (restoreFromClusterSnapshotRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getPreferredMaintenanceWindow()));
        }
        if (restoreFromClusterSnapshotRequest.getAutomatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)restoreFromClusterSnapshotRequest.getAutomatedSnapshotRetentionPeriod()));
        }
        if (restoreFromClusterSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getKmsKeyId()));
        }
        if (restoreFromClusterSnapshotRequest.getNodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getNodeType()));
        }
        if (restoreFromClusterSnapshotRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getAdditionalInfo()));
        }
        return request;
    }
}

