/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ram.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes a resource share in RAM.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ResourceShare" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ResourceShare implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the resource share
     * </p>
     */
    private String resourceShareArn;
    /**
     * <p>
     * The name of the resource share.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the resource share.
     * </p>
     */
    private String owningAccountId;
    /**
     * <p>
     * Indicates whether principals outside your organization in Organizations can be associated with a resource share.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>False</code> – the resource share can be shared with only accounts in the same organization as the account
     * that owns the resource share.
     * </p>
     * </li>
     * </ul>
     */
    private Boolean allowExternalPrincipals;
    /**
     * <p>
     * The current status of the resource share.
     * </p>
     */
    private String status;
    /**
     * <p>
     * A message about the status of the resource share.
     * </p>
     */
    private String statusMessage;
    /**
     * <p>
     * The tag key and value pairs attached to the resource share.
     * </p>
     */
    private java.util.List<Tag> tags;
    /**
     * <p>
     * The date and time when the resource share was created.
     * </p>
     */
    private java.util.Date creationTime;
    /**
     * <p>
     * The date and time when the resource share was last updated.
     * </p>
     */
    private java.util.Date lastUpdatedTime;
    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     */
    private String featureSet;

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the resource share
     * </p>
     * 
     * @param resourceShareArn
     *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *        Name (ARN)</a> of the resource share
     */

    public void setResourceShareArn(String resourceShareArn) {
        this.resourceShareArn = resourceShareArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the resource share
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of the resource share
     */

    public String getResourceShareArn() {
        return this.resourceShareArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the resource share
     * </p>
     * 
     * @param resourceShareArn
     *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *        Name (ARN)</a> of the resource share
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withResourceShareArn(String resourceShareArn) {
        setResourceShareArn(resourceShareArn);
        return this;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @param name
     *        The name of the resource share.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @return The name of the resource share.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @param name
     *        The name of the resource share.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the resource share.
     * </p>
     * 
     * @param owningAccountId
     *        The ID of the Amazon Web Services account that owns the resource share.
     */

    public void setOwningAccountId(String owningAccountId) {
        this.owningAccountId = owningAccountId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the resource share.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the resource share.
     */

    public String getOwningAccountId() {
        return this.owningAccountId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the resource share.
     * </p>
     * 
     * @param owningAccountId
     *        The ID of the Amazon Web Services account that owns the resource share.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withOwningAccountId(String owningAccountId) {
        setOwningAccountId(owningAccountId);
        return this;
    }

    /**
     * <p>
     * Indicates whether principals outside your organization in Organizations can be associated with a resource share.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>False</code> – the resource share can be shared with only accounts in the same organization as the account
     * that owns the resource share.
     * </p>
     * </li>
     * </ul>
     * 
     * @param allowExternalPrincipals
     *        Indicates whether principals outside your organization in Organizations can be associated with a resource
     *        share.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>False</code> – the resource share can be shared with only accounts in the same organization as the
     *        account that owns the resource share.
     *        </p>
     *        </li>
     */

    public void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
        this.allowExternalPrincipals = allowExternalPrincipals;
    }

    /**
     * <p>
     * Indicates whether principals outside your organization in Organizations can be associated with a resource share.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>False</code> – the resource share can be shared with only accounts in the same organization as the account
     * that owns the resource share.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether principals outside your organization in Organizations can be associated with a resource
     *         share.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>False</code> – the resource share can be shared with only accounts in the same organization as the
     *         account that owns the resource share.
     *         </p>
     *         </li>
     */

    public Boolean getAllowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    /**
     * <p>
     * Indicates whether principals outside your organization in Organizations can be associated with a resource share.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>False</code> – the resource share can be shared with only accounts in the same organization as the account
     * that owns the resource share.
     * </p>
     * </li>
     * </ul>
     * 
     * @param allowExternalPrincipals
     *        Indicates whether principals outside your organization in Organizations can be associated with a resource
     *        share.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>False</code> – the resource share can be shared with only accounts in the same organization as the
     *        account that owns the resource share.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withAllowExternalPrincipals(Boolean allowExternalPrincipals) {
        setAllowExternalPrincipals(allowExternalPrincipals);
        return this;
    }

    /**
     * <p>
     * Indicates whether principals outside your organization in Organizations can be associated with a resource share.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>False</code> – the resource share can be shared with only accounts in the same organization as the account
     * that owns the resource share.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether principals outside your organization in Organizations can be associated with a resource
     *         share.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>True</code> – the resource share can be shared with any Amazon Web Services account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>False</code> – the resource share can be shared with only accounts in the same organization as the
     *         account that owns the resource share.
     *         </p>
     *         </li>
     */

    public Boolean isAllowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    /**
     * <p>
     * The current status of the resource share.
     * </p>
     * 
     * @param status
     *        The current status of the resource share.
     * @see ResourceShareStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The current status of the resource share.
     * </p>
     * 
     * @return The current status of the resource share.
     * @see ResourceShareStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The current status of the resource share.
     * </p>
     * 
     * @param status
     *        The current status of the resource share.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ResourceShareStatus
     */

    public ResourceShare withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The current status of the resource share.
     * </p>
     * 
     * @param status
     *        The current status of the resource share.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ResourceShareStatus
     */

    public ResourceShare withStatus(ResourceShareStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * A message about the status of the resource share.
     * </p>
     * 
     * @param statusMessage
     *        A message about the status of the resource share.
     */

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    /**
     * <p>
     * A message about the status of the resource share.
     * </p>
     * 
     * @return A message about the status of the resource share.
     */

    public String getStatusMessage() {
        return this.statusMessage;
    }

    /**
     * <p>
     * A message about the status of the resource share.
     * </p>
     * 
     * @param statusMessage
     *        A message about the status of the resource share.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withStatusMessage(String statusMessage) {
        setStatusMessage(statusMessage);
        return this;
    }

    /**
     * <p>
     * The tag key and value pairs attached to the resource share.
     * </p>
     * 
     * @return The tag key and value pairs attached to the resource share.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tag key and value pairs attached to the resource share.
     * </p>
     * 
     * @param tags
     *        The tag key and value pairs attached to the resource share.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * The tag key and value pairs attached to the resource share.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The tag key and value pairs attached to the resource share.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tag key and value pairs attached to the resource share.
     * </p>
     * 
     * @param tags
     *        The tag key and value pairs attached to the resource share.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * The date and time when the resource share was created.
     * </p>
     * 
     * @param creationTime
     *        The date and time when the resource share was created.
     */

    public void setCreationTime(java.util.Date creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * <p>
     * The date and time when the resource share was created.
     * </p>
     * 
     * @return The date and time when the resource share was created.
     */

    public java.util.Date getCreationTime() {
        return this.creationTime;
    }

    /**
     * <p>
     * The date and time when the resource share was created.
     * </p>
     * 
     * @param creationTime
     *        The date and time when the resource share was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withCreationTime(java.util.Date creationTime) {
        setCreationTime(creationTime);
        return this;
    }

    /**
     * <p>
     * The date and time when the resource share was last updated.
     * </p>
     * 
     * @param lastUpdatedTime
     *        The date and time when the resource share was last updated.
     */

    public void setLastUpdatedTime(java.util.Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    /**
     * <p>
     * The date and time when the resource share was last updated.
     * </p>
     * 
     * @return The date and time when the resource share was last updated.
     */

    public java.util.Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    /**
     * <p>
     * The date and time when the resource share was last updated.
     * </p>
     * 
     * @param lastUpdatedTime
     *        The date and time when the resource share was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceShare withLastUpdatedTime(java.util.Date lastUpdatedTime) {
        setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * 
     * @param featureSet
     *        Indicates what features are available for this resource share. This parameter can have one of the
     *        following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *        all principals you share the resource share with. You can modify these resource shares in RAM using the
     *        console or APIs. This resource share might have been created by RAM, or it might have been
     *        <b>CREATED_FROM_POLICY</b> and then promoted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy.
     *        That policy did not match any existing managed permissions, so RAM created this customer managed
     *        permission automatically on the customer's behalf based on the attached policy document. This type of
     *        resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *        RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *        the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress.
     *        This value changes to <code>STANDARD</code> when complete.
     *        </p>
     *        </li>
     * @see ResourceShareFeatureSet
     */

    public void setFeatureSet(String featureSet) {
        this.featureSet = featureSet;
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates what features are available for this resource share. This parameter can have one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *         all principals you share the resource share with. You can modify these resource shares in RAM using the
     *         console or APIs. This resource share might have been created by RAM, or it might have been
     *         <b>CREATED_FROM_POLICY</b> and then promoted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based
     *         policy. That policy did not match any existing managed permissions, so RAM created this customer managed
     *         permission automatically on the customer's behalf based on the attached policy document. This type of
     *         resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *         RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *         the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in
     *         progress. This value changes to <code>STANDARD</code> when complete.
     *         </p>
     *         </li>
     * @see ResourceShareFeatureSet
     */

    public String getFeatureSet() {
        return this.featureSet;
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * 
     * @param featureSet
     *        Indicates what features are available for this resource share. This parameter can have one of the
     *        following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *        all principals you share the resource share with. You can modify these resource shares in RAM using the
     *        console or APIs. This resource share might have been created by RAM, or it might have been
     *        <b>CREATED_FROM_POLICY</b> and then promoted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy.
     *        That policy did not match any existing managed permissions, so RAM created this customer managed
     *        permission automatically on the customer's behalf based on the attached policy document. This type of
     *        resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *        RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *        the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress.
     *        This value changes to <code>STANDARD</code> when complete.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ResourceShareFeatureSet
     */

    public ResourceShare withFeatureSet(String featureSet) {
        setFeatureSet(featureSet);
        return this;
    }

    /**
     * <p>
     * Indicates what features are available for this resource share. This parameter can have one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to all
     * principals you share the resource share with. You can modify these resource shares in RAM using the console or
     * APIs. This resource share might have been created by RAM, or it might have been <b>CREATED_FROM_POLICY</b> and
     * then promoted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy. That
     * policy did not match any existing managed permissions, so RAM created this customer managed permission
     * automatically on the customer's behalf based on the attached policy document. This type of resource share is
     * visible only to the Amazon Web Services account that created it. You can't modify it in RAM unless you promote
     * it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but the
     * customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress. This value
     * changes to <code>STANDARD</code> when complete.
     * </p>
     * </li>
     * </ul>
     * 
     * @param featureSet
     *        Indicates what features are available for this resource share. This parameter can have one of the
     *        following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>STANDARD</b> – A resource share that supports all functionality. These resource shares are visible to
     *        all principals you share the resource share with. You can modify these resource shares in RAM using the
     *        console or APIs. This resource share might have been created by RAM, or it might have been
     *        <b>CREATED_FROM_POLICY</b> and then promoted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>CREATED_FROM_POLICY</b> – The customer manually shared a resource by attaching a resource-based policy.
     *        That policy did not match any existing managed permissions, so RAM created this customer managed
     *        permission automatically on the customer's behalf based on the attached policy document. This type of
     *        resource share is visible only to the Amazon Web Services account that created it. You can't modify it in
     *        RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>PROMOTING_TO_STANDARD</b> – This resource share was originally <code>CREATED_FROM_POLICY</code>, but
     *        the customer ran the <a>PromoteResourceShareCreatedFromPolicy</a> and that operation is still in progress.
     *        This value changes to <code>STANDARD</code> when complete.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ResourceShareFeatureSet
     */

    public ResourceShare withFeatureSet(ResourceShareFeatureSet featureSet) {
        this.featureSet = featureSet.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getResourceShareArn() != null)
            sb.append("ResourceShareArn: ").append(getResourceShareArn()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getOwningAccountId() != null)
            sb.append("OwningAccountId: ").append(getOwningAccountId()).append(",");
        if (getAllowExternalPrincipals() != null)
            sb.append("AllowExternalPrincipals: ").append(getAllowExternalPrincipals()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getStatusMessage() != null)
            sb.append("StatusMessage: ").append(getStatusMessage()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getCreationTime() != null)
            sb.append("CreationTime: ").append(getCreationTime()).append(",");
        if (getLastUpdatedTime() != null)
            sb.append("LastUpdatedTime: ").append(getLastUpdatedTime()).append(",");
        if (getFeatureSet() != null)
            sb.append("FeatureSet: ").append(getFeatureSet());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ResourceShare == false)
            return false;
        ResourceShare other = (ResourceShare) obj;
        if (other.getResourceShareArn() == null ^ this.getResourceShareArn() == null)
            return false;
        if (other.getResourceShareArn() != null && other.getResourceShareArn().equals(this.getResourceShareArn()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getOwningAccountId() == null ^ this.getOwningAccountId() == null)
            return false;
        if (other.getOwningAccountId() != null && other.getOwningAccountId().equals(this.getOwningAccountId()) == false)
            return false;
        if (other.getAllowExternalPrincipals() == null ^ this.getAllowExternalPrincipals() == null)
            return false;
        if (other.getAllowExternalPrincipals() != null && other.getAllowExternalPrincipals().equals(this.getAllowExternalPrincipals()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null)
            return false;
        if (other.getStatusMessage() != null && other.getStatusMessage().equals(this.getStatusMessage()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getCreationTime() == null ^ this.getCreationTime() == null)
            return false;
        if (other.getCreationTime() != null && other.getCreationTime().equals(this.getCreationTime()) == false)
            return false;
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null)
            return false;
        if (other.getLastUpdatedTime() != null && other.getLastUpdatedTime().equals(this.getLastUpdatedTime()) == false)
            return false;
        if (other.getFeatureSet() == null ^ this.getFeatureSet() == null)
            return false;
        if (other.getFeatureSet() != null && other.getFeatureSet().equals(this.getFeatureSet()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getResourceShareArn() == null) ? 0 : getResourceShareArn().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getOwningAccountId() == null) ? 0 : getOwningAccountId().hashCode());
        hashCode = prime * hashCode + ((getAllowExternalPrincipals() == null) ? 0 : getAllowExternalPrincipals().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getStatusMessage() == null) ? 0 : getStatusMessage().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getCreationTime() == null) ? 0 : getCreationTime().hashCode());
        hashCode = prime * hashCode + ((getLastUpdatedTime() == null) ? 0 : getLastUpdatedTime().hashCode());
        hashCode = prime * hashCode + ((getFeatureSet() == null) ? 0 : getFeatureSet().hashCode());
        return hashCode;
    }

    @Override
    public ResourceShare clone() {
        try {
            return (ResourceShare) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.ram.model.transform.ResourceShareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
