/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ram.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateResourceShareRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private List<String> resourceArns;
    private List<String> principals;
    private List<Tag> tags;
    private Boolean allowExternalPrincipals;
    private String clientToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateResourceShareRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getResourceArns() {
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new ArrayList<String>(resourceArns);
    }

    public CreateResourceShareRequest withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add(ele);
        }
        return this;
    }

    public CreateResourceShareRequest withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<String> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<String>(principals);
    }

    public CreateResourceShareRequest withPrincipals(String ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<String>(principals.length));
        }
        for (String ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public CreateResourceShareRequest withPrincipals(Collection<String> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateResourceShareRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateResourceShareRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
        this.allowExternalPrincipals = allowExternalPrincipals;
    }

    public Boolean getAllowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    public CreateResourceShareRequest withAllowExternalPrincipals(Boolean allowExternalPrincipals) {
        this.setAllowExternalPrincipals(allowExternalPrincipals);
        return this;
    }

    public Boolean isAllowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateResourceShareRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: ").append(this.getResourceArns()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAllowExternalPrincipals() != null) {
            sb.append("AllowExternalPrincipals: ").append(this.getAllowExternalPrincipals()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceShareRequest)) {
            return false;
        }
        CreateResourceShareRequest other = (CreateResourceShareRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        if (other.getPrincipals() != null && !other.getPrincipals().equals(this.getPrincipals())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAllowExternalPrincipals() == null ^ this.getAllowExternalPrincipals() == null) {
            return false;
        }
        if (other.getAllowExternalPrincipals() != null && !other.getAllowExternalPrincipals().equals(this.getAllowExternalPrincipals())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAllowExternalPrincipals() == null ? 0 : this.getAllowExternalPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateResourceShareRequest clone() {
        return (CreateResourceShareRequest)super.clone();
    }
}

