/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CategoryFilterMatchOperator;
import com.amazonaws.services.quicksight.model.CategoryFilterSelectAllOptions;
import com.amazonaws.services.quicksight.model.FilterNullOption;
import com.amazonaws.services.quicksight.model.transform.CustomFilterListConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomFilterListConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String matchOperator;
    private List<String> categoryValues;
    private String selectAllOptions;
    private String nullOption;

    public void setMatchOperator(String matchOperator) {
        this.matchOperator = matchOperator;
    }

    public String getMatchOperator() {
        return this.matchOperator;
    }

    public CustomFilterListConfiguration withMatchOperator(String matchOperator) {
        this.setMatchOperator(matchOperator);
        return this;
    }

    public CustomFilterListConfiguration withMatchOperator(CategoryFilterMatchOperator matchOperator) {
        this.matchOperator = matchOperator.toString();
        return this;
    }

    public List<String> getCategoryValues() {
        return this.categoryValues;
    }

    public void setCategoryValues(Collection<String> categoryValues) {
        if (categoryValues == null) {
            this.categoryValues = null;
            return;
        }
        this.categoryValues = new ArrayList<String>(categoryValues);
    }

    public CustomFilterListConfiguration withCategoryValues(String ... categoryValues) {
        if (this.categoryValues == null) {
            this.setCategoryValues(new ArrayList<String>(categoryValues.length));
        }
        for (String ele : categoryValues) {
            this.categoryValues.add(ele);
        }
        return this;
    }

    public CustomFilterListConfiguration withCategoryValues(Collection<String> categoryValues) {
        this.setCategoryValues(categoryValues);
        return this;
    }

    public void setSelectAllOptions(String selectAllOptions) {
        this.selectAllOptions = selectAllOptions;
    }

    public String getSelectAllOptions() {
        return this.selectAllOptions;
    }

    public CustomFilterListConfiguration withSelectAllOptions(String selectAllOptions) {
        this.setSelectAllOptions(selectAllOptions);
        return this;
    }

    public CustomFilterListConfiguration withSelectAllOptions(CategoryFilterSelectAllOptions selectAllOptions) {
        this.selectAllOptions = selectAllOptions.toString();
        return this;
    }

    public void setNullOption(String nullOption) {
        this.nullOption = nullOption;
    }

    public String getNullOption() {
        return this.nullOption;
    }

    public CustomFilterListConfiguration withNullOption(String nullOption) {
        this.setNullOption(nullOption);
        return this;
    }

    public CustomFilterListConfiguration withNullOption(FilterNullOption nullOption) {
        this.nullOption = nullOption.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMatchOperator() != null) {
            sb.append("MatchOperator: ").append(this.getMatchOperator()).append(",");
        }
        if (this.getCategoryValues() != null) {
            sb.append("CategoryValues: ").append(this.getCategoryValues()).append(",");
        }
        if (this.getSelectAllOptions() != null) {
            sb.append("SelectAllOptions: ").append(this.getSelectAllOptions()).append(",");
        }
        if (this.getNullOption() != null) {
            sb.append("NullOption: ").append(this.getNullOption());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFilterListConfiguration)) {
            return false;
        }
        CustomFilterListConfiguration other = (CustomFilterListConfiguration)obj;
        if (other.getMatchOperator() == null ^ this.getMatchOperator() == null) {
            return false;
        }
        if (other.getMatchOperator() != null && !other.getMatchOperator().equals(this.getMatchOperator())) {
            return false;
        }
        if (other.getCategoryValues() == null ^ this.getCategoryValues() == null) {
            return false;
        }
        if (other.getCategoryValues() != null && !other.getCategoryValues().equals(this.getCategoryValues())) {
            return false;
        }
        if (other.getSelectAllOptions() == null ^ this.getSelectAllOptions() == null) {
            return false;
        }
        if (other.getSelectAllOptions() != null && !other.getSelectAllOptions().equals(this.getSelectAllOptions())) {
            return false;
        }
        if (other.getNullOption() == null ^ this.getNullOption() == null) {
            return false;
        }
        return other.getNullOption() == null || other.getNullOption().equals(this.getNullOption());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMatchOperator() == null ? 0 : this.getMatchOperator().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryValues() == null ? 0 : this.getCategoryValues().hashCode());
        hashCode = 31 * hashCode + (this.getSelectAllOptions() == null ? 0 : this.getSelectAllOptions().hashCode());
        hashCode = 31 * hashCode + (this.getNullOption() == null ? 0 : this.getNullOption().hashCode());
        return hashCode;
    }

    public CustomFilterListConfiguration clone() {
        try {
            return (CustomFilterListConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomFilterListConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

