/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AggregationSortConfiguration;
import com.amazonaws.services.quicksight.model.ColumnIdentifier;
import com.amazonaws.services.quicksight.model.DefaultFilterControlConfiguration;
import com.amazonaws.services.quicksight.model.TimeGranularity;
import com.amazonaws.services.quicksight.model.transform.TopBottomFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopBottomFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String filterId;
    private ColumnIdentifier column;
    private Integer limit;
    private List<AggregationSortConfiguration> aggregationSortConfigurations;
    private String timeGranularity;
    private String parameterName;
    private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public TopBottomFilter withFilterId(String filterId) {
        this.setFilterId(filterId);
        return this;
    }

    public void setColumn(ColumnIdentifier column) {
        this.column = column;
    }

    public ColumnIdentifier getColumn() {
        return this.column;
    }

    public TopBottomFilter withColumn(ColumnIdentifier column) {
        this.setColumn(column);
        return this;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public TopBottomFilter withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public List<AggregationSortConfiguration> getAggregationSortConfigurations() {
        return this.aggregationSortConfigurations;
    }

    public void setAggregationSortConfigurations(Collection<AggregationSortConfiguration> aggregationSortConfigurations) {
        if (aggregationSortConfigurations == null) {
            this.aggregationSortConfigurations = null;
            return;
        }
        this.aggregationSortConfigurations = new ArrayList<AggregationSortConfiguration>(aggregationSortConfigurations);
    }

    public TopBottomFilter withAggregationSortConfigurations(AggregationSortConfiguration ... aggregationSortConfigurations) {
        if (this.aggregationSortConfigurations == null) {
            this.setAggregationSortConfigurations(new ArrayList<AggregationSortConfiguration>(aggregationSortConfigurations.length));
        }
        for (AggregationSortConfiguration ele : aggregationSortConfigurations) {
            this.aggregationSortConfigurations.add(ele);
        }
        return this;
    }

    public TopBottomFilter withAggregationSortConfigurations(Collection<AggregationSortConfiguration> aggregationSortConfigurations) {
        this.setAggregationSortConfigurations(aggregationSortConfigurations);
        return this;
    }

    public void setTimeGranularity(String timeGranularity) {
        this.timeGranularity = timeGranularity;
    }

    public String getTimeGranularity() {
        return this.timeGranularity;
    }

    public TopBottomFilter withTimeGranularity(String timeGranularity) {
        this.setTimeGranularity(timeGranularity);
        return this;
    }

    public TopBottomFilter withTimeGranularity(TimeGranularity timeGranularity) {
        this.timeGranularity = timeGranularity.toString();
        return this;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public TopBottomFilter withParameterName(String parameterName) {
        this.setParameterName(parameterName);
        return this;
    }

    public void setDefaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
        this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
    }

    public DefaultFilterControlConfiguration getDefaultFilterControlConfiguration() {
        return this.defaultFilterControlConfiguration;
    }

    public TopBottomFilter withDefaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
        this.setDefaultFilterControlConfiguration(defaultFilterControlConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterId() != null) {
            sb.append("FilterId: ").append(this.getFilterId()).append(",");
        }
        if (this.getColumn() != null) {
            sb.append("Column: ").append(this.getColumn()).append(",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getAggregationSortConfigurations() != null) {
            sb.append("AggregationSortConfigurations: ").append(this.getAggregationSortConfigurations()).append(",");
        }
        if (this.getTimeGranularity() != null) {
            sb.append("TimeGranularity: ").append(this.getTimeGranularity()).append(",");
        }
        if (this.getParameterName() != null) {
            sb.append("ParameterName: ").append(this.getParameterName()).append(",");
        }
        if (this.getDefaultFilterControlConfiguration() != null) {
            sb.append("DefaultFilterControlConfiguration: ").append(this.getDefaultFilterControlConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopBottomFilter)) {
            return false;
        }
        TopBottomFilter other = (TopBottomFilter)obj;
        if (other.getFilterId() == null ^ this.getFilterId() == null) {
            return false;
        }
        if (other.getFilterId() != null && !other.getFilterId().equals(this.getFilterId())) {
            return false;
        }
        if (other.getColumn() == null ^ this.getColumn() == null) {
            return false;
        }
        if (other.getColumn() != null && !other.getColumn().equals(this.getColumn())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getAggregationSortConfigurations() == null ^ this.getAggregationSortConfigurations() == null) {
            return false;
        }
        if (other.getAggregationSortConfigurations() != null && !other.getAggregationSortConfigurations().equals(this.getAggregationSortConfigurations())) {
            return false;
        }
        if (other.getTimeGranularity() == null ^ this.getTimeGranularity() == null) {
            return false;
        }
        if (other.getTimeGranularity() != null && !other.getTimeGranularity().equals(this.getTimeGranularity())) {
            return false;
        }
        if (other.getParameterName() == null ^ this.getParameterName() == null) {
            return false;
        }
        if (other.getParameterName() != null && !other.getParameterName().equals(this.getParameterName())) {
            return false;
        }
        if (other.getDefaultFilterControlConfiguration() == null ^ this.getDefaultFilterControlConfiguration() == null) {
            return false;
        }
        return other.getDefaultFilterControlConfiguration() == null || other.getDefaultFilterControlConfiguration().equals(this.getDefaultFilterControlConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterId() == null ? 0 : this.getFilterId().hashCode());
        hashCode = 31 * hashCode + (this.getColumn() == null ? 0 : this.getColumn().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationSortConfigurations() == null ? 0 : this.getAggregationSortConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTimeGranularity() == null ? 0 : this.getTimeGranularity().hashCode());
        hashCode = 31 * hashCode + (this.getParameterName() == null ? 0 : this.getParameterName().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultFilterControlConfiguration() == null ? 0 : this.getDefaultFilterControlConfiguration().hashCode());
        return hashCode;
    }

    public TopBottomFilter clone() {
        try {
            return (TopBottomFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopBottomFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

