/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AggType;
import com.amazonaws.services.quicksight.model.TopicTimeGranularity;
import com.amazonaws.services.quicksight.model.transform.AggFunctionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AggFunction
implements Serializable,
Cloneable,
StructuredPojo {
    private String aggregation;
    private Map<String, String> aggregationFunctionParameters;
    private String period;
    private String periodField;

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public AggFunction withAggregation(String aggregation) {
        this.setAggregation(aggregation);
        return this;
    }

    public AggFunction withAggregation(AggType aggregation) {
        this.aggregation = aggregation.toString();
        return this;
    }

    public Map<String, String> getAggregationFunctionParameters() {
        return this.aggregationFunctionParameters;
    }

    public void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
        this.aggregationFunctionParameters = aggregationFunctionParameters;
    }

    public AggFunction withAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
        this.setAggregationFunctionParameters(aggregationFunctionParameters);
        return this;
    }

    public AggFunction addAggregationFunctionParametersEntry(String key, String value) {
        if (null == this.aggregationFunctionParameters) {
            this.aggregationFunctionParameters = new HashMap<String, String>();
        }
        if (this.aggregationFunctionParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.aggregationFunctionParameters.put(key, value);
        return this;
    }

    public AggFunction clearAggregationFunctionParametersEntries() {
        this.aggregationFunctionParameters = null;
        return this;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getPeriod() {
        return this.period;
    }

    public AggFunction withPeriod(String period) {
        this.setPeriod(period);
        return this;
    }

    public AggFunction withPeriod(TopicTimeGranularity period) {
        this.period = period.toString();
        return this;
    }

    public void setPeriodField(String periodField) {
        this.periodField = periodField;
    }

    public String getPeriodField() {
        return this.periodField;
    }

    public AggFunction withPeriodField(String periodField) {
        this.setPeriodField(periodField);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAggregation() != null) {
            sb.append("Aggregation: ").append(this.getAggregation()).append(",");
        }
        if (this.getAggregationFunctionParameters() != null) {
            sb.append("AggregationFunctionParameters: ").append(this.getAggregationFunctionParameters()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getPeriodField() != null) {
            sb.append("PeriodField: ").append(this.getPeriodField());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggFunction)) {
            return false;
        }
        AggFunction other = (AggFunction)obj;
        if (other.getAggregation() == null ^ this.getAggregation() == null) {
            return false;
        }
        if (other.getAggregation() != null && !other.getAggregation().equals(this.getAggregation())) {
            return false;
        }
        if (other.getAggregationFunctionParameters() == null ^ this.getAggregationFunctionParameters() == null) {
            return false;
        }
        if (other.getAggregationFunctionParameters() != null && !other.getAggregationFunctionParameters().equals(this.getAggregationFunctionParameters())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getPeriodField() == null ^ this.getPeriodField() == null) {
            return false;
        }
        return other.getPeriodField() == null || other.getPeriodField().equals(this.getPeriodField());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAggregation() == null ? 0 : this.getAggregation().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationFunctionParameters() == null ? 0 : this.getAggregationFunctionParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPeriodField() == null ? 0 : this.getPeriodField().hashCode());
        return hashCode;
    }

    public AggFunction clone() {
        try {
            return (AggFunction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggFunctionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

