/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.RedshiftIAMParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RedshiftIAMParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private String roleArn;
    private String databaseUser;
    private List<String> databaseGroups;
    private Boolean autoCreateDatabaseUser;

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public RedshiftIAMParameters withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public RedshiftIAMParameters withDatabaseUser(String databaseUser) {
        this.setDatabaseUser(databaseUser);
        return this;
    }

    public List<String> getDatabaseGroups() {
        return this.databaseGroups;
    }

    public void setDatabaseGroups(Collection<String> databaseGroups) {
        if (databaseGroups == null) {
            this.databaseGroups = null;
            return;
        }
        this.databaseGroups = new ArrayList<String>(databaseGroups);
    }

    public RedshiftIAMParameters withDatabaseGroups(String ... databaseGroups) {
        if (this.databaseGroups == null) {
            this.setDatabaseGroups(new ArrayList<String>(databaseGroups.length));
        }
        for (String ele : databaseGroups) {
            this.databaseGroups.add(ele);
        }
        return this;
    }

    public RedshiftIAMParameters withDatabaseGroups(Collection<String> databaseGroups) {
        this.setDatabaseGroups(databaseGroups);
        return this;
    }

    public void setAutoCreateDatabaseUser(Boolean autoCreateDatabaseUser) {
        this.autoCreateDatabaseUser = autoCreateDatabaseUser;
    }

    public Boolean getAutoCreateDatabaseUser() {
        return this.autoCreateDatabaseUser;
    }

    public RedshiftIAMParameters withAutoCreateDatabaseUser(Boolean autoCreateDatabaseUser) {
        this.setAutoCreateDatabaseUser(autoCreateDatabaseUser);
        return this;
    }

    public Boolean isAutoCreateDatabaseUser() {
        return this.autoCreateDatabaseUser;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getDatabaseUser() != null) {
            sb.append("DatabaseUser: ").append(this.getDatabaseUser()).append(",");
        }
        if (this.getDatabaseGroups() != null) {
            sb.append("DatabaseGroups: ").append(this.getDatabaseGroups()).append(",");
        }
        if (this.getAutoCreateDatabaseUser() != null) {
            sb.append("AutoCreateDatabaseUser: ").append(this.getAutoCreateDatabaseUser());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftIAMParameters)) {
            return false;
        }
        RedshiftIAMParameters other = (RedshiftIAMParameters)obj;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getDatabaseUser() == null ^ this.getDatabaseUser() == null) {
            return false;
        }
        if (other.getDatabaseUser() != null && !other.getDatabaseUser().equals(this.getDatabaseUser())) {
            return false;
        }
        if (other.getDatabaseGroups() == null ^ this.getDatabaseGroups() == null) {
            return false;
        }
        if (other.getDatabaseGroups() != null && !other.getDatabaseGroups().equals(this.getDatabaseGroups())) {
            return false;
        }
        if (other.getAutoCreateDatabaseUser() == null ^ this.getAutoCreateDatabaseUser() == null) {
            return false;
        }
        return other.getAutoCreateDatabaseUser() == null || other.getAutoCreateDatabaseUser().equals(this.getAutoCreateDatabaseUser());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseUser() == null ? 0 : this.getDatabaseUser().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseGroups() == null ? 0 : this.getDatabaseGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAutoCreateDatabaseUser() == null ? 0 : this.getAutoCreateDatabaseUser().hashCode());
        return hashCode;
    }

    public RedshiftIAMParameters clone() {
        try {
            return (RedshiftIAMParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftIAMParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

