/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.PivotTableFieldSubtotalOptions;
import com.amazonaws.services.quicksight.model.PivotTableSubtotalLevel;
import com.amazonaws.services.quicksight.model.TableCellStyle;
import com.amazonaws.services.quicksight.model.TableStyleTarget;
import com.amazonaws.services.quicksight.model.Visibility;
import com.amazonaws.services.quicksight.model.transform.SubtotalOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubtotalOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String totalsVisibility;
    private String customLabel;
    private String fieldLevel;
    private List<PivotTableFieldSubtotalOptions> fieldLevelOptions;
    private TableCellStyle totalCellStyle;
    private TableCellStyle valueCellStyle;
    private TableCellStyle metricHeaderCellStyle;
    private List<TableStyleTarget> styleTargets;

    public void setTotalsVisibility(String totalsVisibility) {
        this.totalsVisibility = totalsVisibility;
    }

    public String getTotalsVisibility() {
        return this.totalsVisibility;
    }

    public SubtotalOptions withTotalsVisibility(String totalsVisibility) {
        this.setTotalsVisibility(totalsVisibility);
        return this;
    }

    public SubtotalOptions withTotalsVisibility(Visibility totalsVisibility) {
        this.totalsVisibility = totalsVisibility.toString();
        return this;
    }

    public void setCustomLabel(String customLabel) {
        this.customLabel = customLabel;
    }

    public String getCustomLabel() {
        return this.customLabel;
    }

    public SubtotalOptions withCustomLabel(String customLabel) {
        this.setCustomLabel(customLabel);
        return this;
    }

    public void setFieldLevel(String fieldLevel) {
        this.fieldLevel = fieldLevel;
    }

    public String getFieldLevel() {
        return this.fieldLevel;
    }

    public SubtotalOptions withFieldLevel(String fieldLevel) {
        this.setFieldLevel(fieldLevel);
        return this;
    }

    public SubtotalOptions withFieldLevel(PivotTableSubtotalLevel fieldLevel) {
        this.fieldLevel = fieldLevel.toString();
        return this;
    }

    public List<PivotTableFieldSubtotalOptions> getFieldLevelOptions() {
        return this.fieldLevelOptions;
    }

    public void setFieldLevelOptions(Collection<PivotTableFieldSubtotalOptions> fieldLevelOptions) {
        if (fieldLevelOptions == null) {
            this.fieldLevelOptions = null;
            return;
        }
        this.fieldLevelOptions = new ArrayList<PivotTableFieldSubtotalOptions>(fieldLevelOptions);
    }

    public SubtotalOptions withFieldLevelOptions(PivotTableFieldSubtotalOptions ... fieldLevelOptions) {
        if (this.fieldLevelOptions == null) {
            this.setFieldLevelOptions(new ArrayList<PivotTableFieldSubtotalOptions>(fieldLevelOptions.length));
        }
        for (PivotTableFieldSubtotalOptions ele : fieldLevelOptions) {
            this.fieldLevelOptions.add(ele);
        }
        return this;
    }

    public SubtotalOptions withFieldLevelOptions(Collection<PivotTableFieldSubtotalOptions> fieldLevelOptions) {
        this.setFieldLevelOptions(fieldLevelOptions);
        return this;
    }

    public void setTotalCellStyle(TableCellStyle totalCellStyle) {
        this.totalCellStyle = totalCellStyle;
    }

    public TableCellStyle getTotalCellStyle() {
        return this.totalCellStyle;
    }

    public SubtotalOptions withTotalCellStyle(TableCellStyle totalCellStyle) {
        this.setTotalCellStyle(totalCellStyle);
        return this;
    }

    public void setValueCellStyle(TableCellStyle valueCellStyle) {
        this.valueCellStyle = valueCellStyle;
    }

    public TableCellStyle getValueCellStyle() {
        return this.valueCellStyle;
    }

    public SubtotalOptions withValueCellStyle(TableCellStyle valueCellStyle) {
        this.setValueCellStyle(valueCellStyle);
        return this;
    }

    public void setMetricHeaderCellStyle(TableCellStyle metricHeaderCellStyle) {
        this.metricHeaderCellStyle = metricHeaderCellStyle;
    }

    public TableCellStyle getMetricHeaderCellStyle() {
        return this.metricHeaderCellStyle;
    }

    public SubtotalOptions withMetricHeaderCellStyle(TableCellStyle metricHeaderCellStyle) {
        this.setMetricHeaderCellStyle(metricHeaderCellStyle);
        return this;
    }

    public List<TableStyleTarget> getStyleTargets() {
        return this.styleTargets;
    }

    public void setStyleTargets(Collection<TableStyleTarget> styleTargets) {
        if (styleTargets == null) {
            this.styleTargets = null;
            return;
        }
        this.styleTargets = new ArrayList<TableStyleTarget>(styleTargets);
    }

    public SubtotalOptions withStyleTargets(TableStyleTarget ... styleTargets) {
        if (this.styleTargets == null) {
            this.setStyleTargets(new ArrayList<TableStyleTarget>(styleTargets.length));
        }
        for (TableStyleTarget ele : styleTargets) {
            this.styleTargets.add(ele);
        }
        return this;
    }

    public SubtotalOptions withStyleTargets(Collection<TableStyleTarget> styleTargets) {
        this.setStyleTargets(styleTargets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalsVisibility() != null) {
            sb.append("TotalsVisibility: ").append(this.getTotalsVisibility()).append(",");
        }
        if (this.getCustomLabel() != null) {
            sb.append("CustomLabel: ").append(this.getCustomLabel()).append(",");
        }
        if (this.getFieldLevel() != null) {
            sb.append("FieldLevel: ").append(this.getFieldLevel()).append(",");
        }
        if (this.getFieldLevelOptions() != null) {
            sb.append("FieldLevelOptions: ").append(this.getFieldLevelOptions()).append(",");
        }
        if (this.getTotalCellStyle() != null) {
            sb.append("TotalCellStyle: ").append(this.getTotalCellStyle()).append(",");
        }
        if (this.getValueCellStyle() != null) {
            sb.append("ValueCellStyle: ").append(this.getValueCellStyle()).append(",");
        }
        if (this.getMetricHeaderCellStyle() != null) {
            sb.append("MetricHeaderCellStyle: ").append(this.getMetricHeaderCellStyle()).append(",");
        }
        if (this.getStyleTargets() != null) {
            sb.append("StyleTargets: ").append(this.getStyleTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubtotalOptions)) {
            return false;
        }
        SubtotalOptions other = (SubtotalOptions)obj;
        if (other.getTotalsVisibility() == null ^ this.getTotalsVisibility() == null) {
            return false;
        }
        if (other.getTotalsVisibility() != null && !other.getTotalsVisibility().equals(this.getTotalsVisibility())) {
            return false;
        }
        if (other.getCustomLabel() == null ^ this.getCustomLabel() == null) {
            return false;
        }
        if (other.getCustomLabel() != null && !other.getCustomLabel().equals(this.getCustomLabel())) {
            return false;
        }
        if (other.getFieldLevel() == null ^ this.getFieldLevel() == null) {
            return false;
        }
        if (other.getFieldLevel() != null && !other.getFieldLevel().equals(this.getFieldLevel())) {
            return false;
        }
        if (other.getFieldLevelOptions() == null ^ this.getFieldLevelOptions() == null) {
            return false;
        }
        if (other.getFieldLevelOptions() != null && !other.getFieldLevelOptions().equals(this.getFieldLevelOptions())) {
            return false;
        }
        if (other.getTotalCellStyle() == null ^ this.getTotalCellStyle() == null) {
            return false;
        }
        if (other.getTotalCellStyle() != null && !other.getTotalCellStyle().equals(this.getTotalCellStyle())) {
            return false;
        }
        if (other.getValueCellStyle() == null ^ this.getValueCellStyle() == null) {
            return false;
        }
        if (other.getValueCellStyle() != null && !other.getValueCellStyle().equals(this.getValueCellStyle())) {
            return false;
        }
        if (other.getMetricHeaderCellStyle() == null ^ this.getMetricHeaderCellStyle() == null) {
            return false;
        }
        if (other.getMetricHeaderCellStyle() != null && !other.getMetricHeaderCellStyle().equals(this.getMetricHeaderCellStyle())) {
            return false;
        }
        if (other.getStyleTargets() == null ^ this.getStyleTargets() == null) {
            return false;
        }
        return other.getStyleTargets() == null || other.getStyleTargets().equals(this.getStyleTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalsVisibility() == null ? 0 : this.getTotalsVisibility().hashCode());
        hashCode = 31 * hashCode + (this.getCustomLabel() == null ? 0 : this.getCustomLabel().hashCode());
        hashCode = 31 * hashCode + (this.getFieldLevel() == null ? 0 : this.getFieldLevel().hashCode());
        hashCode = 31 * hashCode + (this.getFieldLevelOptions() == null ? 0 : this.getFieldLevelOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCellStyle() == null ? 0 : this.getTotalCellStyle().hashCode());
        hashCode = 31 * hashCode + (this.getValueCellStyle() == null ? 0 : this.getValueCellStyle().hashCode());
        hashCode = 31 * hashCode + (this.getMetricHeaderCellStyle() == null ? 0 : this.getMetricHeaderCellStyle().hashCode());
        hashCode = 31 * hashCode + (this.getStyleTargets() == null ? 0 : this.getStyleTargets().hashCode());
        return hashCode;
    }

    public SubtotalOptions clone() {
        try {
            return (SubtotalOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubtotalOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

