/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CustomContentImageScalingConfiguration;
import com.amazonaws.services.quicksight.model.CustomContentType;
import com.amazonaws.services.quicksight.model.VisualInteractionOptions;
import com.amazonaws.services.quicksight.model.transform.CustomContentConfigurationMarshaller;
import java.io.Serializable;

public class CustomContentConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String contentUrl;
    private String contentType;
    private String imageScaling;
    private VisualInteractionOptions interactions;

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public CustomContentConfiguration withContentUrl(String contentUrl) {
        this.setContentUrl(contentUrl);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public CustomContentConfiguration withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public CustomContentConfiguration withContentType(CustomContentType contentType) {
        this.contentType = contentType.toString();
        return this;
    }

    public void setImageScaling(String imageScaling) {
        this.imageScaling = imageScaling;
    }

    public String getImageScaling() {
        return this.imageScaling;
    }

    public CustomContentConfiguration withImageScaling(String imageScaling) {
        this.setImageScaling(imageScaling);
        return this;
    }

    public CustomContentConfiguration withImageScaling(CustomContentImageScalingConfiguration imageScaling) {
        this.imageScaling = imageScaling.toString();
        return this;
    }

    public void setInteractions(VisualInteractionOptions interactions) {
        this.interactions = interactions;
    }

    public VisualInteractionOptions getInteractions() {
        return this.interactions;
    }

    public CustomContentConfiguration withInteractions(VisualInteractionOptions interactions) {
        this.setInteractions(interactions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContentUrl() != null) {
            sb.append("ContentUrl: ").append(this.getContentUrl()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getImageScaling() != null) {
            sb.append("ImageScaling: ").append(this.getImageScaling()).append(",");
        }
        if (this.getInteractions() != null) {
            sb.append("Interactions: ").append(this.getInteractions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomContentConfiguration)) {
            return false;
        }
        CustomContentConfiguration other = (CustomContentConfiguration)obj;
        if (other.getContentUrl() == null ^ this.getContentUrl() == null) {
            return false;
        }
        if (other.getContentUrl() != null && !other.getContentUrl().equals(this.getContentUrl())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getImageScaling() == null ^ this.getImageScaling() == null) {
            return false;
        }
        if (other.getImageScaling() != null && !other.getImageScaling().equals(this.getImageScaling())) {
            return false;
        }
        if (other.getInteractions() == null ^ this.getInteractions() == null) {
            return false;
        }
        return other.getInteractions() == null || other.getInteractions().equals(this.getInteractions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContentUrl() == null ? 0 : this.getContentUrl().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getImageScaling() == null ? 0 : this.getImageScaling().hashCode());
        hashCode = 31 * hashCode + (this.getInteractions() == null ? 0 : this.getInteractions().hashCode());
        return hashCode;
    }

    public CustomContentConfiguration clone() {
        try {
            return (CustomContentConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomContentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

