/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataSetReference;
import com.amazonaws.services.quicksight.model.transform.TemplateSourceAnalysisMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TemplateSourceAnalysis
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<DataSetReference> dataSetReferences;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public TemplateSourceAnalysis withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<DataSetReference> getDataSetReferences() {
        return this.dataSetReferences;
    }

    public void setDataSetReferences(Collection<DataSetReference> dataSetReferences) {
        if (dataSetReferences == null) {
            this.dataSetReferences = null;
            return;
        }
        this.dataSetReferences = new ArrayList<DataSetReference>(dataSetReferences);
    }

    public TemplateSourceAnalysis withDataSetReferences(DataSetReference ... dataSetReferences) {
        if (this.dataSetReferences == null) {
            this.setDataSetReferences(new ArrayList<DataSetReference>(dataSetReferences.length));
        }
        for (DataSetReference ele : dataSetReferences) {
            this.dataSetReferences.add(ele);
        }
        return this;
    }

    public TemplateSourceAnalysis withDataSetReferences(Collection<DataSetReference> dataSetReferences) {
        this.setDataSetReferences(dataSetReferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDataSetReferences() != null) {
            sb.append("DataSetReferences: ").append(this.getDataSetReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSourceAnalysis)) {
            return false;
        }
        TemplateSourceAnalysis other = (TemplateSourceAnalysis)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDataSetReferences() == null ^ this.getDataSetReferences() == null) {
            return false;
        }
        return other.getDataSetReferences() == null || other.getDataSetReferences().equals(this.getDataSetReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDataSetReferences() == null ? 0 : this.getDataSetReferences().hashCode());
        return hashCode;
    }

    public TemplateSourceAnalysis clone() {
        try {
            return (TemplateSourceAnalysis)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TemplateSourceAnalysisMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

