/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FieldSortOptions;
import com.amazonaws.services.quicksight.model.PaginationConfiguration;
import com.amazonaws.services.quicksight.model.transform.TableSortConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TableSortConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FieldSortOptions> rowSort;
    private PaginationConfiguration paginationConfiguration;

    public List<FieldSortOptions> getRowSort() {
        return this.rowSort;
    }

    public void setRowSort(Collection<FieldSortOptions> rowSort) {
        if (rowSort == null) {
            this.rowSort = null;
            return;
        }
        this.rowSort = new ArrayList<FieldSortOptions>(rowSort);
    }

    public TableSortConfiguration withRowSort(FieldSortOptions ... rowSort) {
        if (this.rowSort == null) {
            this.setRowSort(new ArrayList<FieldSortOptions>(rowSort.length));
        }
        for (FieldSortOptions ele : rowSort) {
            this.rowSort.add(ele);
        }
        return this;
    }

    public TableSortConfiguration withRowSort(Collection<FieldSortOptions> rowSort) {
        this.setRowSort(rowSort);
        return this;
    }

    public void setPaginationConfiguration(PaginationConfiguration paginationConfiguration) {
        this.paginationConfiguration = paginationConfiguration;
    }

    public PaginationConfiguration getPaginationConfiguration() {
        return this.paginationConfiguration;
    }

    public TableSortConfiguration withPaginationConfiguration(PaginationConfiguration paginationConfiguration) {
        this.setPaginationConfiguration(paginationConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRowSort() != null) {
            sb.append("RowSort: ").append(this.getRowSort()).append(",");
        }
        if (this.getPaginationConfiguration() != null) {
            sb.append("PaginationConfiguration: ").append(this.getPaginationConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableSortConfiguration)) {
            return false;
        }
        TableSortConfiguration other = (TableSortConfiguration)obj;
        if (other.getRowSort() == null ^ this.getRowSort() == null) {
            return false;
        }
        if (other.getRowSort() != null && !other.getRowSort().equals(this.getRowSort())) {
            return false;
        }
        if (other.getPaginationConfiguration() == null ^ this.getPaginationConfiguration() == null) {
            return false;
        }
        return other.getPaginationConfiguration() == null || other.getPaginationConfiguration().equals(this.getPaginationConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRowSort() == null ? 0 : this.getRowSort().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationConfiguration() == null ? 0 : this.getPaginationConfiguration().hashCode());
        return hashCode;
    }

    public TableSortConfiguration clone() {
        try {
            return (TableSortConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableSortConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

