/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.NamedEntityDefinition;
import com.amazonaws.services.quicksight.model.SemanticEntityType;
import com.amazonaws.services.quicksight.model.transform.TopicNamedEntityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicNamedEntity
implements Serializable,
Cloneable,
StructuredPojo {
    private String entityName;
    private String entityDescription;
    private List<String> entitySynonyms;
    private SemanticEntityType semanticEntityType;
    private List<NamedEntityDefinition> definition;

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public TopicNamedEntity withEntityName(String entityName) {
        this.setEntityName(entityName);
        return this;
    }

    public void setEntityDescription(String entityDescription) {
        this.entityDescription = entityDescription;
    }

    public String getEntityDescription() {
        return this.entityDescription;
    }

    public TopicNamedEntity withEntityDescription(String entityDescription) {
        this.setEntityDescription(entityDescription);
        return this;
    }

    public List<String> getEntitySynonyms() {
        return this.entitySynonyms;
    }

    public void setEntitySynonyms(Collection<String> entitySynonyms) {
        if (entitySynonyms == null) {
            this.entitySynonyms = null;
            return;
        }
        this.entitySynonyms = new ArrayList<String>(entitySynonyms);
    }

    public TopicNamedEntity withEntitySynonyms(String ... entitySynonyms) {
        if (this.entitySynonyms == null) {
            this.setEntitySynonyms(new ArrayList<String>(entitySynonyms.length));
        }
        for (String ele : entitySynonyms) {
            this.entitySynonyms.add(ele);
        }
        return this;
    }

    public TopicNamedEntity withEntitySynonyms(Collection<String> entitySynonyms) {
        this.setEntitySynonyms(entitySynonyms);
        return this;
    }

    public void setSemanticEntityType(SemanticEntityType semanticEntityType) {
        this.semanticEntityType = semanticEntityType;
    }

    public SemanticEntityType getSemanticEntityType() {
        return this.semanticEntityType;
    }

    public TopicNamedEntity withSemanticEntityType(SemanticEntityType semanticEntityType) {
        this.setSemanticEntityType(semanticEntityType);
        return this;
    }

    public List<NamedEntityDefinition> getDefinition() {
        return this.definition;
    }

    public void setDefinition(Collection<NamedEntityDefinition> definition) {
        if (definition == null) {
            this.definition = null;
            return;
        }
        this.definition = new ArrayList<NamedEntityDefinition>(definition);
    }

    public TopicNamedEntity withDefinition(NamedEntityDefinition ... definition) {
        if (this.definition == null) {
            this.setDefinition(new ArrayList<NamedEntityDefinition>(definition.length));
        }
        for (NamedEntityDefinition ele : definition) {
            this.definition.add(ele);
        }
        return this;
    }

    public TopicNamedEntity withDefinition(Collection<NamedEntityDefinition> definition) {
        this.setDefinition(definition);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntityName() != null) {
            sb.append("EntityName: ").append(this.getEntityName()).append(",");
        }
        if (this.getEntityDescription() != null) {
            sb.append("EntityDescription: ").append(this.getEntityDescription()).append(",");
        }
        if (this.getEntitySynonyms() != null) {
            sb.append("EntitySynonyms: ").append(this.getEntitySynonyms()).append(",");
        }
        if (this.getSemanticEntityType() != null) {
            sb.append("SemanticEntityType: ").append(this.getSemanticEntityType()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append(this.getDefinition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicNamedEntity)) {
            return false;
        }
        TopicNamedEntity other = (TopicNamedEntity)obj;
        if (other.getEntityName() == null ^ this.getEntityName() == null) {
            return false;
        }
        if (other.getEntityName() != null && !other.getEntityName().equals(this.getEntityName())) {
            return false;
        }
        if (other.getEntityDescription() == null ^ this.getEntityDescription() == null) {
            return false;
        }
        if (other.getEntityDescription() != null && !other.getEntityDescription().equals(this.getEntityDescription())) {
            return false;
        }
        if (other.getEntitySynonyms() == null ^ this.getEntitySynonyms() == null) {
            return false;
        }
        if (other.getEntitySynonyms() != null && !other.getEntitySynonyms().equals(this.getEntitySynonyms())) {
            return false;
        }
        if (other.getSemanticEntityType() == null ^ this.getSemanticEntityType() == null) {
            return false;
        }
        if (other.getSemanticEntityType() != null && !other.getSemanticEntityType().equals(this.getSemanticEntityType())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        return other.getDefinition() == null || other.getDefinition().equals(this.getDefinition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntityName() == null ? 0 : this.getEntityName().hashCode());
        hashCode = 31 * hashCode + (this.getEntityDescription() == null ? 0 : this.getEntityDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEntitySynonyms() == null ? 0 : this.getEntitySynonyms().hashCode());
        hashCode = 31 * hashCode + (this.getSemanticEntityType() == null ? 0 : this.getSemanticEntityType().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        return hashCode;
    }

    public TopicNamedEntity clone() {
        try {
            return (TopicNamedEntity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicNamedEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

