/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.quicksight.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ThemeConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ThemeConfigurationMarshaller {

    private static final MarshallingInfo<StructuredPojo> DATACOLORPALETTE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataColorPalette").build();
    private static final MarshallingInfo<StructuredPojo> UICOLORPALETTE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UIColorPalette").build();
    private static final MarshallingInfo<StructuredPojo> SHEET_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sheet").build();
    private static final MarshallingInfo<StructuredPojo> TYPOGRAPHY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Typography").build();

    private static final ThemeConfigurationMarshaller instance = new ThemeConfigurationMarshaller();

    public static ThemeConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ThemeConfiguration themeConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (themeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(themeConfiguration.getDataColorPalette(), DATACOLORPALETTE_BINDING);
            protocolMarshaller.marshall(themeConfiguration.getUIColorPalette(), UICOLORPALETTE_BINDING);
            protocolMarshaller.marshall(themeConfiguration.getSheet(), SHEET_BINDING);
            protocolMarshaller.marshall(themeConfiguration.getTypography(), TYPOGRAPHY_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
