/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FieldSortOptions;
import com.amazonaws.services.quicksight.model.ItemsLimitConfiguration;
import com.amazonaws.services.quicksight.model.transform.WaterfallChartSortConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WaterfallChartSortConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FieldSortOptions> categorySort;
    private ItemsLimitConfiguration breakdownItemsLimit;

    public List<FieldSortOptions> getCategorySort() {
        return this.categorySort;
    }

    public void setCategorySort(Collection<FieldSortOptions> categorySort) {
        if (categorySort == null) {
            this.categorySort = null;
            return;
        }
        this.categorySort = new ArrayList<FieldSortOptions>(categorySort);
    }

    public WaterfallChartSortConfiguration withCategorySort(FieldSortOptions ... categorySort) {
        if (this.categorySort == null) {
            this.setCategorySort(new ArrayList<FieldSortOptions>(categorySort.length));
        }
        for (FieldSortOptions ele : categorySort) {
            this.categorySort.add(ele);
        }
        return this;
    }

    public WaterfallChartSortConfiguration withCategorySort(Collection<FieldSortOptions> categorySort) {
        this.setCategorySort(categorySort);
        return this;
    }

    public void setBreakdownItemsLimit(ItemsLimitConfiguration breakdownItemsLimit) {
        this.breakdownItemsLimit = breakdownItemsLimit;
    }

    public ItemsLimitConfiguration getBreakdownItemsLimit() {
        return this.breakdownItemsLimit;
    }

    public WaterfallChartSortConfiguration withBreakdownItemsLimit(ItemsLimitConfiguration breakdownItemsLimit) {
        this.setBreakdownItemsLimit(breakdownItemsLimit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategorySort() != null) {
            sb.append("CategorySort: ").append(this.getCategorySort()).append(",");
        }
        if (this.getBreakdownItemsLimit() != null) {
            sb.append("BreakdownItemsLimit: ").append(this.getBreakdownItemsLimit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaterfallChartSortConfiguration)) {
            return false;
        }
        WaterfallChartSortConfiguration other = (WaterfallChartSortConfiguration)obj;
        if (other.getCategorySort() == null ^ this.getCategorySort() == null) {
            return false;
        }
        if (other.getCategorySort() != null && !other.getCategorySort().equals(this.getCategorySort())) {
            return false;
        }
        if (other.getBreakdownItemsLimit() == null ^ this.getBreakdownItemsLimit() == null) {
            return false;
        }
        return other.getBreakdownItemsLimit() == null || other.getBreakdownItemsLimit().equals(this.getBreakdownItemsLimit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategorySort() == null ? 0 : this.getCategorySort().hashCode());
        hashCode = 31 * hashCode + (this.getBreakdownItemsLimit() == null ? 0 : this.getBreakdownItemsLimit().hashCode());
        return hashCode;
    }

    public WaterfallChartSortConfiguration clone() {
        try {
            return (WaterfallChartSortConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WaterfallChartSortConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

