/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FieldSortOptions;
import com.amazonaws.services.quicksight.model.ItemsLimitConfiguration;
import com.amazonaws.services.quicksight.model.transform.SankeyDiagramSortConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SankeyDiagramSortConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FieldSortOptions> weightSort;
    private ItemsLimitConfiguration sourceItemsLimit;
    private ItemsLimitConfiguration destinationItemsLimit;

    public List<FieldSortOptions> getWeightSort() {
        return this.weightSort;
    }

    public void setWeightSort(Collection<FieldSortOptions> weightSort) {
        if (weightSort == null) {
            this.weightSort = null;
            return;
        }
        this.weightSort = new ArrayList<FieldSortOptions>(weightSort);
    }

    public SankeyDiagramSortConfiguration withWeightSort(FieldSortOptions ... weightSort) {
        if (this.weightSort == null) {
            this.setWeightSort(new ArrayList<FieldSortOptions>(weightSort.length));
        }
        for (FieldSortOptions ele : weightSort) {
            this.weightSort.add(ele);
        }
        return this;
    }

    public SankeyDiagramSortConfiguration withWeightSort(Collection<FieldSortOptions> weightSort) {
        this.setWeightSort(weightSort);
        return this;
    }

    public void setSourceItemsLimit(ItemsLimitConfiguration sourceItemsLimit) {
        this.sourceItemsLimit = sourceItemsLimit;
    }

    public ItemsLimitConfiguration getSourceItemsLimit() {
        return this.sourceItemsLimit;
    }

    public SankeyDiagramSortConfiguration withSourceItemsLimit(ItemsLimitConfiguration sourceItemsLimit) {
        this.setSourceItemsLimit(sourceItemsLimit);
        return this;
    }

    public void setDestinationItemsLimit(ItemsLimitConfiguration destinationItemsLimit) {
        this.destinationItemsLimit = destinationItemsLimit;
    }

    public ItemsLimitConfiguration getDestinationItemsLimit() {
        return this.destinationItemsLimit;
    }

    public SankeyDiagramSortConfiguration withDestinationItemsLimit(ItemsLimitConfiguration destinationItemsLimit) {
        this.setDestinationItemsLimit(destinationItemsLimit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWeightSort() != null) {
            sb.append("WeightSort: ").append(this.getWeightSort()).append(",");
        }
        if (this.getSourceItemsLimit() != null) {
            sb.append("SourceItemsLimit: ").append(this.getSourceItemsLimit()).append(",");
        }
        if (this.getDestinationItemsLimit() != null) {
            sb.append("DestinationItemsLimit: ").append(this.getDestinationItemsLimit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SankeyDiagramSortConfiguration)) {
            return false;
        }
        SankeyDiagramSortConfiguration other = (SankeyDiagramSortConfiguration)obj;
        if (other.getWeightSort() == null ^ this.getWeightSort() == null) {
            return false;
        }
        if (other.getWeightSort() != null && !other.getWeightSort().equals(this.getWeightSort())) {
            return false;
        }
        if (other.getSourceItemsLimit() == null ^ this.getSourceItemsLimit() == null) {
            return false;
        }
        if (other.getSourceItemsLimit() != null && !other.getSourceItemsLimit().equals(this.getSourceItemsLimit())) {
            return false;
        }
        if (other.getDestinationItemsLimit() == null ^ this.getDestinationItemsLimit() == null) {
            return false;
        }
        return other.getDestinationItemsLimit() == null || other.getDestinationItemsLimit().equals(this.getDestinationItemsLimit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWeightSort() == null ? 0 : this.getWeightSort().hashCode());
        hashCode = 31 * hashCode + (this.getSourceItemsLimit() == null ? 0 : this.getSourceItemsLimit().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationItemsLimit() == null ? 0 : this.getDestinationItemsLimit().hashCode());
        return hashCode;
    }

    public SankeyDiagramSortConfiguration clone() {
        try {
            return (SankeyDiagramSortConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SankeyDiagramSortConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

