/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.GridLayoutElement;

@SdkInternalApi
public class GridLayoutElementMarshaller {
    private static final MarshallingInfo<String> ELEMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElementId").build();
    private static final MarshallingInfo<String> ELEMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElementType").build();
    private static final MarshallingInfo<Integer> COLUMNINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnIndex").build();
    private static final MarshallingInfo<Integer> COLUMNSPAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnSpan").build();
    private static final MarshallingInfo<Integer> ROWINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowIndex").build();
    private static final MarshallingInfo<Integer> ROWSPAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowSpan").build();
    private static final GridLayoutElementMarshaller instance = new GridLayoutElementMarshaller();

    public static GridLayoutElementMarshaller getInstance() {
        return instance;
    }

    public void marshall(GridLayoutElement gridLayoutElement, ProtocolMarshaller protocolMarshaller) {
        if (gridLayoutElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)gridLayoutElement.getElementId(), ELEMENTID_BINDING);
            protocolMarshaller.marshall((Object)gridLayoutElement.getElementType(), ELEMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)gridLayoutElement.getColumnIndex(), COLUMNINDEX_BINDING);
            protocolMarshaller.marshall((Object)gridLayoutElement.getColumnSpan(), COLUMNSPAN_BINDING);
            protocolMarshaller.marshall((Object)gridLayoutElement.getRowIndex(), ROWINDEX_BINDING);
            protocolMarshaller.marshall((Object)gridLayoutElement.getRowSpan(), ROWSPAN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

