/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.CustomParameterValues;
import java.util.List;

@SdkInternalApi
public class CustomParameterValuesMarshaller {
    private static final MarshallingInfo<List> STRINGVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringValues").build();
    private static final MarshallingInfo<List> INTEGERVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerValues").build();
    private static final MarshallingInfo<List> DECIMALVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DecimalValues").build();
    private static final MarshallingInfo<List> DATETIMEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DateTimeValues").build();
    private static final CustomParameterValuesMarshaller instance = new CustomParameterValuesMarshaller();

    public static CustomParameterValuesMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomParameterValues customParameterValues, ProtocolMarshaller protocolMarshaller) {
        if (customParameterValues == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(customParameterValues.getStringValues(), STRINGVALUES_BINDING);
            protocolMarshaller.marshall(customParameterValues.getIntegerValues(), INTEGERVALUES_BINDING);
            protocolMarshaller.marshall(customParameterValues.getDecimalValues(), DECIMALVALUES_BINDING);
            protocolMarshaller.marshall(customParameterValues.getDateTimeValues(), DATETIMEVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

