/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.PhysicalTable;

@SdkInternalApi
public class PhysicalTableMarshaller {
    private static final MarshallingInfo<StructuredPojo> RELATIONALTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelationalTable").build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMSQL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomSql").build();
    private static final MarshallingInfo<StructuredPojo> S3SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Source").build();
    private static final PhysicalTableMarshaller instance = new PhysicalTableMarshaller();

    public static PhysicalTableMarshaller getInstance() {
        return instance;
    }

    public void marshall(PhysicalTable physicalTable, ProtocolMarshaller protocolMarshaller) {
        if (physicalTable == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)physicalTable.getRelationalTable(), RELATIONALTABLE_BINDING);
            protocolMarshaller.marshall((Object)physicalTable.getCustomSql(), CUSTOMSQL_BINDING);
            protocolMarshaller.marshall((Object)physicalTable.getS3Source(), S3SOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

