/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.DataSetReference;

@SdkInternalApi
public class DataSetReferenceMarshaller {
    private static final MarshallingInfo<String> DATASETPLACEHOLDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSetPlaceholder").build();
    private static final MarshallingInfo<String> DATASETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSetArn").build();
    private static final DataSetReferenceMarshaller instance = new DataSetReferenceMarshaller();

    public static DataSetReferenceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSetReference dataSetReference, ProtocolMarshaller protocolMarshaller) {
        if (dataSetReference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSetReference.getDataSetPlaceholder(), DATASETPLACEHOLDER_BINDING);
            protocolMarshaller.marshall((Object)dataSetReference.getDataSetArn(), DATASETARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

